<script>
				$(document).ready(function () {
					$('#btn-add').on('click', function () {
						$('#formData')[0].reset();
						$('#id_tahun').val('');
						$('#formModal').modal('show');
					});

					$('.btn-edit').on('click', function () {
						const id = $(this).data('id');
						$.get(`/tahunAjaran/getData_tahunAjaran/${id}`, function (data) {
							$('#id_tahun').val(data.id_tahun);
							$('#tahun_pelajaran').val(data.tahun_pelajaran);
							$('#status').val(data.status);
							$('#semester_aktif').val(data.semester_aktif);
							$('#formModal').modal('show');
						});
					});

					$('#formData').on('submit', function (e) {
						e.preventDefault();
						$.post('/tahunAjaran/save_tahunAjaran', $(this).serialize(), function (response) {
							if (response.status == 'success') {
								toastr.success(response.message, 'Success'); // Pesan sukses
							}else{
								toastr.error(response.message, 'Error'); // Pesan sukses
							}
							location.reload();
						});
					});

					$('.btn-delete').on('click', function () {
						const id = $(this).data('id');
						if (confirm('Are you sure you want to delete this data?')) {
							$.ajax({
								url: `/tahunAjaran/delete_tahunAjaran/${id}`,
								type: 'DELETE',
								success: function (response) {
									toastr.success(response.message, 'Success'); // Pesan sukses
                        location.reload(); // Reload page after delete
                    },
                    error: function () {
                    	toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
						}
					});

				});
			</script>