<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    $(document).ready(function() {
        $('#formData').on('submit', function(e) {
            e.preventDefault();
            const id = $("#id").val();

            if (!id) {
                $.post('/pesertaDidik/save', $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                    $('#formModal').modal('hide');
                    location.reload();
                });
            } else {
                const id = $('#id').val();
                $.post(`/pesertaDidik/update/${id}`, $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                    $('#formModal').modal('hide');
                    location.reload();
                });
            }


        });

    });

    function showExcelImportModal() {
        $('#excelFile').val(''); // Kosongkan input file
        new bootstrap.Modal(document.getElementById('import')).show();
    }

    function viewData(id) {
        $.ajax({
            url: `/pesertaDidik/getDataView/${id}`,
            method: 'GET',
            success: function(response) {
                $('#dataview').html(response);
                $("#view").modal('show');
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
            }
        });

    }

    function editData(id) {
        $.ajax({
            url: `/pesertaDidik/getData/${id}`,
            method: 'GET',
            success: function(response) {
                $('#id').val(response.id_pd);
                $('#nama_lengkap').val(response.nama_lengkap);
                $('#nisn').val(response.nisn);
                $('#jk').val(response.jk);
                $('#tmp_lahir').val(response.tmp_lahir);
                $('#tgl_lahir').val(response.tgl_lahir);
                $('#no_hp').val(response.no_hp);
                $('#email').val(response.email);
                $('#alamat').val(response.alamat);
                $('#nama_ayah').val(response.nama_ayah);
                $('#nama_ibu').val(response.nama_ibu);
                $('#no_hp_ayah').val(response.no_hp_ayah);
                $('#no_hp_ibu').val(response.no_hp_ibu);
                $('#kode_jurusan').val(response.kode_jurusan);
                $('#kode_kelas').val(response.kode_kelas);
                $('#kode_rombel').val(response.kode_rombel);
                $('#status').val(response.status_pd);
                $('#tahun_pelajaran').val(response.tahun_pelajaran);
                $('#semester_aktif').val(response.semester_aktif);
                $('#formModal').modal('show');
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
            }
        });
    }

    function importXls() {
        const fileInput = document.getElementById('excelFile');
        const file = fileInput.files[0];

        if (!file) {
            alert('Harap pilih file terlebih dahulu.');
            return;
        }

        const reader = new FileReader();

        reader.onload = function(event) {
            const data = new Uint8Array(event.target.result);
            const workbook = XLSX.read(data, {
                type: 'array'
            });

            // Ambil sheet pertama
            const sheetName = workbook.SheetNames[0];
            const sheet = workbook.Sheets[sheetName];

            // Konversi sheet ke JSON, mulai dari baris ke-2
            const jsonData = XLSX.utils.sheet_to_json(sheet, {
                header: 1,
                range: 1
            });

            // Format data untuk dikirim ke server
            const formattedData = jsonData.map(row => ({
                nisn: row[1],
                nik: row[2],
                nama_lengkap: row[3],
                tmp_lahir: row[4],
                tgl_lahir: row[5],
                jk: row[6],
                alamat: row[7],
                email: row[8],
                no_hp: row[9],
                nama_ayah: row[10],
                no_hp_ayah: row[11],
                nama_ibu: row[12],
                no_hp_ibu: row[13],
                nama_wali: row[14],
                no_hp_wali: row[15],
                status: row[16],
                kode_jurusan: row[17],
                kode_kelas: row[18],
                kode_rombel: row[19],
                key: row[20],
                password: row[21],
            }));

            console.log(formattedData); // Debug data

            // Kirim data ke server
            $.ajax({
                url: '/pesertaDidik/import',
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    data: formattedData
                }),
                success: function(response) {
                    $('#import').modal('hide');
                    location.reload();
                    toastr.success(response.message, 'Success'); // Pesan sukses
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    $('#import').modal('hide');
                    location.reload();
                    toastr.error('Gagal Import Files', 'error'); // Pesan sukses
                }
            });
        };

        reader.readAsArrayBuffer(file);
    }


    function deleteData(id) {
        if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
            $.ajax({
                url: `/pesertaDidik/delete/${id}`,
                method: 'DELETE',
                success: function(response) {
                    toastr.success(response.message, 'Success'); // Pesan sukses
                    location.reload();
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    toastr.error(response.message, 'Error'); // Pesan peringatan
                }
            });
        }
    }
</script>