<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    $(document).ready(function() {

      
        $('#btn-add').on('click', function() {
            $('#formData')[0].reset();
            $('#id').val('');
            $('#formModal').modal('show');
        });

        $('#akses').on('change', function() {
            const akses = $('#akses').val();
            if (akses == 'walikelas') {
                $('#rombel').removeAttr('disabled');
            }else{
                $('#rombel').attr('disabled','');
                $('#rombel').val('');
            }
            
        }); 

        $('#formData').on('submit', function(e) {
            e.preventDefault();
            const id = $("#id").val();

            if (!id) {
                $.post('/user/save_user', $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                    $('#formModal').modal('hide');
                    location.reload();
                });
            }else{
                const id = $('#id').val();
                $.post(`/user/update/${id}`, $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                    $('#formModal').modal('hide');
                    location.reload();
                });
            }
           

        });

  

    });

function editData(id) {
    $.ajax({
        url: `/user/getData_user/${id}`,
        method: 'GET',
        success: function(response) {
            $('#id').val(response.id_user);
            $('#nama_lengkap').val(response.nama_lengkap);
            $('#username').val(response.username);
            $('#akses').val(response.akses);
            $('#rombel').val(response.rombel);
            $('#status').val(response.status);
            $('#formModal').modal('show');
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function deleteData(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        $.ajax({
            url: `/user/delete_user/${id}`,
            method: 'DELETE',
            success: function(response) {
                toastr.success(response.message, 'Success'); // Pesan sukses
                location.reload();
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error(response.message, 'Error'); // Pesan peringatan
            }
        });
    }
} 


function showExcelImportModal() {
        $('#excelFile').val(''); // Kosongkan input file
        new bootstrap.Modal(document.getElementById('import')).show();
    }

    function importXls() {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (!file) {
        alert('Harap pilih file terlebih dahulu.');
        return;
    }

    const reader = new FileReader();

    reader.onload = function (event) {
        const data = new Uint8Array(event.target.result);
        const workbook = XLSX.read(data, { type: 'array' });

        // Ambil sheet pertama
        const sheetName = workbook.SheetNames[0];
        const sheet = workbook.Sheets[sheetName];

        // Konversi sheet ke JSON, mulai dari baris ke-2
        const jsonData = XLSX.utils.sheet_to_json(sheet, { header: 1, range: 1 });

        // Format data untuk dikirim ke server
        const formattedData = jsonData.map(row => ({
          nama_lengkap: row[1],
          akses: row[2],
          rombel: row[3],
          username: row[4],
          password: row[5],
          status: row[6],
        }));

        console.log(formattedData); // Debug data

        // Kirim data ke server
        $.ajax({
            url: '/user/import',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ data: formattedData }),
            success: function (response) {
                $('#import').modal('hide');
               location.reload();
                toastr.success(response.message, 'Success'); // Pesan sukses
            },
            error: function (xhr) {
                console.error(xhr.responseText);
                $('#import').modal('hide');
               location.reload();
                toastr.error('Gagal Import Files', 'error'); // Pesan sukses
            }
        });
    };

    reader.readAsArrayBuffer(file);
}
</script>