<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
    $(document).ready(function () {
        loadData();

        $('#btn-add').on('click', function () {
            $('#formData')[0].reset();
            $('#id').val('');
            $('#formModal').modal('show');
        });

        $('#formData').on('submit', function (e) {
            e.preventDefault();

            const id = $("#id").val();

            if (!id) {
                $.post('/mapel/save_mapel', $(this).serialize(), function (response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                    }
                });
            } else {
                const id = $('#id').val();
                const data = {
                    nama_mapel: $('#kd_mapel').val(),
                    nama_mapel: $('#nama_mapel').val()
                };

                $.ajax({
                    url: `/mapel/update/${id}`,
                    method: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (response) {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                    }
                });


            }

            $('#formModal').modal('hide');
            loadData(); // Refresh tabel setelah update

        });



    });


    function showExcelImportModal() {
        $('#excelFile').val(''); // Kosongkan input file
        new bootstrap.Modal(document.getElementById('excelImportModal')).show();
    }

    function importXls() {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (!file) {
        alert('Harap pilih file terlebih dahulu.');
        return;
    }

    const reader = new FileReader();

    reader.onload = function (event) {
        const data = new Uint8Array(event.target.result);
        const workbook = XLSX.read(data, { type: 'array' });

        // Ambil sheet pertama
        const sheetName = workbook.SheetNames[0];
        const sheet = workbook.Sheets[sheetName];

        // Konversi sheet ke JSON, mulai dari baris ke-2
        const jsonData = XLSX.utils.sheet_to_json(sheet, { header: 1, range: 1 });

        // Format data untuk dikirim ke server
        const formattedData = jsonData.map(row => ({
            kd_mapel: row[0],    // Kolom pertama
            nama_mapel: row[1],  // Kolom kedua
        }));

        console.log(formattedData); // Debug data

        // Kirim data ke server
        $.ajax({
            url: '/mapel/import',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ data: formattedData }),
            success: function (response) {
                $('#excelImportModal').modal('hide');
                loadData(); // Refresh tabel setelah update
                toastr.success(response.message, 'Success'); // Pesan sukses
            },
            error: function (xhr) {
                console.error(xhr.responseText);
                $('#excelImportModal').modal('hide');
                loadData(); // Refresh tabel setelah update
                toastr.error('Gagal Import Files', 'error'); // Pesan sukses
            }
        });
    };

    reader.readAsArrayBuffer(file);
}
    function loadData() {
        $.ajax({
            url: '/mapel/getAll', // Endpoint untuk mendapatkan semua data
            method: 'GET',
            success: function (response) {
                const tbody = $('#dataTable tbody');
                tbody.empty(); // Kosongkan isi tabel sebelumnya

                response.data.forEach((row, index) => {
                    const tr = `
                    <tr>
                        <td>${index + 1}</td> <!-- Nomor otomatis -->
                        <td>${row.kd_mapel}</td>
                        <td>${row.nama_mapel}</td>
                        <td>
                            <button class="btn btn-default btn-sm" onclick="editData(${row.id})"><img src="assets/img/icons/edit.svg" alt="img"></button>
                            <button class="btn btn-default btn-sm" onclick="deleteData(${row.id})"><img src="assets/img/icons/delete.svg" alt="img"></button>
                        </td>
                    </tr>
                `;
                    tbody.append(tr);
                });
            },
            error: function (xhr) {
                console.error(xhr.responseText);
                toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
            }
        });
    }


    function editData(id) {
        $.ajax({
            url: `/mapel/getData_mapel/${id}`,
            method: 'GET',
            success: function (response) {
                $('#id').val(response.id);
                $('#kd_mapel').val(response.kd_mapel);
                $('#nama_mapel').val(response.nama_mapel);
                $('#formModal').modal('show');
            },
            error: function (xhr) {
                console.error(xhr.responseText);
                toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
            }
        });
    }

    function deleteData(id) {
        if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
            $.ajax({
                url: `/mapel/delete_mapel/${id}`,
                method: 'DELETE',
                success: function (response) {
                    toastr.success(response.message, 'Success'); // Pesan sukses
                    loadData(); // Refresh data setelah dihapus
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                    toastr.error(response.message, 'Error'); // Pesan peringatan
                }
            });
        }
    }


</script>