<script>
    $(document).ready(function() {

        setInterval(loadDataAbsensi, 5000);
        loadDataAbsensi();

    });

    function loadDataAbsensi() {
        $.get(`/kbm/loadData`, function(data) {
            $('#load').html(data);
        });
    }

    function mulaiKelas(rombel, jadwal, jumlah) {
        if (confirm('Apakah Anda yakin ingin Memulai KBM Kelas ini.')) {
            const data = {
                rombel: rombel,
                jadwal: jadwal,
                jml_jam: jumlah,
            };

            $.ajax({
                url: `kbm/mulai_kelas`,
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function(data) {
                    toastr.success('Berhasil Mulai kelas', 'Success'); // Pesan peringatan
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    toastr.error('Gagal  Selesai kelas', 'Error'); // Pesan peringatan
                }
            });

        }

    }

    function hapusKelas(id) {
        if (confirm('Apakah Anda yakin ingin Membatalkan KBM Kelas ini.')) {
            $.get(`/kbm/hapus_kelas/${id}`, function(data) {
                toastr.success(data.message, 'Success'); // Pesan sukses
            });
        }

    }

    function selesaiKelas(id) {
        if (confirm('Apakah Anda yakin ingin Menyelesaikan KBM Kelas ini.')) {
            $.get(`/kbm/selesai_kelas/${id}`, function(data) {
                toastr.success(data.message, 'Success'); // Pesan sukses
            });
        }
    }

    function absenKelas(id) {
        $.ajax({
            url: `/kbm/load_data_kelas/${id}`,
            method: 'GET',
            success: function(response) {
                $('#load-pd').html(response);
                $("#absen-kelas").modal('show');
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
            }
        });

    }
</script>