<script>
    $(document).ready(function() {
        loadData();

        $('#btn-add').on('click', function() {
            $('#formData')[0].reset();
            $('#id').val('');
            $('#formModal').modal('show');
        });

        $('#formData').on('submit', function(e) {
            e.preventDefault();
            const id = $("#id").val();

            if (!id) {
                $.post('/jurusan/save_jurusan', $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
            }else{
                const id = $('#id').val();
                const data = {
                    kode_jurusan: $('#kode_jurusan').val(),
                    nama_jurusan: $('#nama_jurusan').val(),
                    status: $('#status').val()
                };

                $.ajax({
                    url: `/jurusan/update/${id}`,
                    method: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (response) {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                    }
                });
            }
            $('#formModal').modal('hide');
            loadData();

        });

    });


function loadData() {
    $.ajax({
        url: '/jurusan/getAll', // Endpoint untuk mendapatkan semua data
        method: 'GET',
        success: function(response) {
            const tbody = $('#dataTable tbody');
            tbody.empty(); // Kosongkan isi tabel sebelumnya

            response.data.forEach((row, index) => {
                const statusBadge = row.status === 'Ya' ?
                    `<span class="badges bg-lightgreen">Ya</span>` :
                    `<span class="badges bg-lightred">Tidak</span>`;
                const tr = `
                    <tr>
                        <td>${index + 1}</td> <!-- Nomor otomatis -->
                        <td>${row.kode_jurusan}</td>
                        <td>${row.nama_jurusan}</td>
                        <td>${statusBadge}</td>
                        <td>
                            <button class="btn btn-default btn-sm" onclick="editData('${row.id}')"><img src="assets/img/icons/edit.svg" alt="img"></button>
                            <button class="btn btn-default btn-sm" onclick="deleteData('${row.id}')"><img src="assets/img/icons/delete.svg" alt="img"></button>
                        </td>
                    </tr>
                `;
                tbody.append(tr);
            });
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function editData(id) {
    $.ajax({
        url: `/jurusan/getData_jurusan/${id}`,
        method: 'GET',
        success: function(response) {
            $('#id').val(response.id);
            $('#kode_jurusan').val(response.kode_jurusan);
            $('#nama_jurusan').val(response.nama_jurusan);
            $('#status').val(response.status);
            $('#formModal').modal('show');
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function deleteData(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        $.ajax({
            url: `/jurusan/delete_jurusan/${id}`,
            method: 'DELETE',
            success: function(response) {
                toastr.success(response.message, 'Success'); // Pesan sukses
                loadData(); // Refresh data setelah dihapus
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error(response.message, 'Error'); // Pesan peringatan
            }
        });
    }
} 
</script>