<script>

$(document).ready(function() {
    loadData();
    loadDataWaktu();
    LoadJadwalPDf();
    $('#formDurasi').on('submit', function (e) {
						e.preventDefault();
						$.post('/jadwal/saveWaktu', $(this).serialize(), function (response) {
							if (response.status == 'success') {
								toastr.success(response.message, 'Success'); // Pesan sukses
							}else{
								toastr.error(response.message, 'Error'); // Pesan sukses
							}
							loadDataWaktu();
						});
					});

                    $('.btn-deleteWaktu').on('click', function () {
						const id = $(this).data('id');
						if (confirm('Are you sure you want to delete this data?')) {
							$.ajax({
								url: `/jadwal/deleteWaktu/${id}`,
								type: 'DELETE',
								success: function (response) {
									toastr.success(response.message, 'Success'); // Pesan sukses
                                    loadDataWaktu();
                    },
                    error: function () {
                    	toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
						}
					});

});


function loadData() {
    $.ajax({
        url: `/jadwal/LoadJadwal/`,
        method: 'GET',
        success: function(data) {
            $('#load').html(data);
        },
        // error: function(xhr) {
        //     console.error(xhr.responseText);
        //     toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        // }
    });
}

function loadDataWaktu() {
    $.ajax({
        url: `/jadwal/waktuBelajar/`,
        method: 'GET',
        success: function(data) {
            $('#loadWaktu').html(data);
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function deleteWaktu(id) {
    if (confirm('Are you sure you want to delete this data?')) {
							$.ajax({
								url: `/jadwal/deleteWaktu/${id}`,
								type: 'DELETE',
								success: function (response) {
									toastr.success(response.message, 'Success'); // Pesan sukses
                                   
                    },
                    error: function () {
                    	toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
						}
                        loadDataWaktu();
}


function generateJadwal() {
    $("#generateModal").modal('show');

}

function waktuBelajar() {
    $("#waktuBelajar").modal('show');
}

function saveJadwal() {
 
    let inputs = document.querySelectorAll("table input, table select");

    inputs.forEach(input => {
        input.addEventListener("change", function() {
            let row = input.closest("tr");
            
            // Ambil data dari baris tabel
            let hari = input.getAttribute("data-hari");
            let jam_ke = input.getAttribute("data-jam");
            let kode_rombel = input.getAttribute("data-rombel");
            let kode_guru = input.value;

       
            $.ajax({
                    url: `jadwal/updateJadwal`,
                    method: 'POST',
                    contentType: 'application/json',
                    // data: JSON.stringify(data),
                    data: JSON.stringify({
                        hari: hari,
                        jam_ke: jam_ke,
                        kode_rombel: kode_rombel,
                        kode_guru: kode_guru
                    }),
                    success: function (response) {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                        loadData();
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                        loadData();
                    }
                });
                  
    });
});

               
}

function generateJadwalPost() {
    $.ajax({
        url: `/jadwal/generate/`,
        method: 'GET',
        success: function(response) {
            toastr.success(response.message, 'Success'); // Pesan sukses
            $("#generateModal").modal('hide');
            loadData();
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function LoadJadwalPDf() {
    $.ajax({
        url: `/jadwalPreview/LoadJadwalPDf/`,
        method: 'GET',
        success: function(data) {
            $('#loadPreview').html(data);
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}
</script>