<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    $(document).ready(function() {

      
        $('#btn-add').on('click', function() {
            $('#formData')[0].reset();
            $('#id').val('');
            $('#formModal').modal('show');
        });

        $('#formData').on('submit', function(e) {
            e.preventDefault();
            const id = $("#id").val();

            if (!id) {
                $.post('/gtk/save_gtk', $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
            }else{
                const id = $('#id').val();
                const data = {
                    nip: $('#nip').val(),
                    nuptk: $('#nuptk').val(),
                    nama_lengkap: $('#nama_lengkap').val(),
                    tm_lahir: $('#tm_lahir').val(),
                    tgl_lahir: $('#tgl_lahir').val(),
                    no_hp: $('#no_hp').val(),
                    jenis_kelamin: $('#jenis_kelamin').val(),
                    kode_guru: $('#kode_guru').val(),
                    status: $('#status').val()
                };

                $.ajax({
                    url: `/gtk/update/${id}`,
                    method: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (response) {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                    }
                });
            }
            $('#formModal').modal('hide');
           location.reload();

        });

  

    });

function editData(id) {
    $.ajax({
        url: `/gtk/getData_gtk/${id}`,
        method: 'GET',
        success: function(response) {
            $('#id').val(response.id_gtk);
            $('#nip').val(response.nip);
            $('#nuptk').val(response.nuptk);
            $('#nama_lengkap').val(response.nama_lengkap);
            $('#tm_lahir').val(response.tm_lahir);
            $('#tgl_lahir').val(response.tgl_lahir);
            $('#jenis_kelamin').val(response.jenis_kelamin);
            $('#no_hp').val(response.no_hp);
            $('#status').val(response.status);
            $('#kode_guru').val(response.kode_guru);
            $('#formModal').modal('show');
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function deleteData(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        $.ajax({
            url: `/gtk/delete_gtk/${id}`,
            method: 'DELETE',
            success: function(response) {
                toastr.success(response.message, 'Success'); // Pesan sukses
                location.reload();
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error(response.message, 'Error'); // Pesan peringatan
            }
        });
    }
} 


function showExcelImportModal() {
        $('#excelFile').val(''); // Kosongkan input file
        new bootstrap.Modal(document.getElementById('import')).show();
    }

    function importXls() {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (!file) {
        alert('Harap pilih file terlebih dahulu.');
        return;
    }

    const reader = new FileReader();

    reader.onload = function (event) {
        const data = new Uint8Array(event.target.result);
        const workbook = XLSX.read(data, { type: 'array' });

        // Ambil sheet pertama
        const sheetName = workbook.SheetNames[0];
        const sheet = workbook.Sheets[sheetName];

        // Konversi sheet ke JSON, mulai dari baris ke-2
        const jsonData = XLSX.utils.sheet_to_json(sheet, { header: 1, range: 1 });

        // Format data untuk dikirim ke server
        const formattedData = jsonData.map(row => ({
            nip: row[1],
          nuptk: row[2],
          nama_lengkap: row[3],
          tm_lahir: row[4],
          tgl_lahir: row[5],
          ijazah_terakhir: row[6],
          no_hp: row[7],
          status: row[8],
          jenis_kelamin: row[9],
          key: row[10],
          kode_guru: row[11],
          password: row[12],
        }));

        console.log(formattedData); // Debug data

        // Kirim data ke server
        $.ajax({
            url: '/gtk/import',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ data: formattedData }),
            success: function (response) {
                $('#import').modal('hide');
               location.reload();
                toastr.success(response.message, 'Success'); // Pesan sukses
            },
            error: function (xhr) {
                console.error(xhr.responseText);
                $('#import').modal('hide');
               location.reload();
                toastr.error('Gagal Import Files', 'error'); // Pesan sukses
            }
        });
    };

    reader.readAsArrayBuffer(file);
}
</script>