<script>
    $(document).ready(function() {
        setInterval(loadData, 5000);
        loadData();

        $('#btn-add').on('click', function() {
            $('#formData')[0].reset();
            $('#id').val('');
            $('#formModal').modal('show');
        });

        $('#formData').on('submit', function(e) {
            e.preventDefault();
            const id = $("#id").val();

            if (!id) {
                $.post('/device/save', $(this).serialize(), function(response) {
                    if (response.status == 'success') {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    } else {
                        toastr.error(response.message, 'Error'); // Pesan sukses
                    }
                });
            }else{
                const id = $('#id').val();
                const data = {
                    kode_kelas: $('#device_id').val(),
                };

                $.ajax({
                    url: `/device/update/${id}`,
                    method: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (response) {
                        toastr.success(response.message, 'Success'); // Pesan sukses
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                        toastr.error(response.message, 'Error'); // Pesan peringatan
                    }
                });
            }
            $('#formModal').modal('hide');
            loadData();

        });

    });

    function updateStatus() {
            $.get('/esp32/status', function(data) {
                let rows = '';
                data.forEach(device => {
                    let statusClass = device.status === 'online' ? 'online' : 'offline';
                    rows += `
                        <tr>
                            <td>${device.device_id}</td>
                            <td>${device.ip_address}</td>
                            <td class="${statusClass}">${device.status}</td>
                            <td>${device.last_seen}</td>
                        </tr>
                    `;
                });
                $('#espTable').html(rows);
            });
        }

function loadData() {
    $.ajax({
        url: '/device/getAll', // Endpoint untuk mendapatkan semua data
        method: 'GET',
        success: function(response) {
            const tbody = $('#dataTable tbody');
            tbody.empty(); // Kosongkan isi tabel sebelumnya

            response.data.forEach((row, index) => {
                const statusBadge = row.status === 'online' ?
                    `<span class="badges bg-lightgreen">Online</span>` :
                    `<span class="badges bg-lightred">Offline</span>`;
                const tr = `
                    <tr>
                        <td>${index + 1}</td> <!-- Nomor otomatis -->
                        <td>${row.device_id}</td>
                        <td>${row.last_seen}</td>
                        <td>${statusBadge}</td>
                        <td>
                            <button class="btn btn-default btn-sm" onclick="editData('${row.id_device}')"><img src="assets/img/icons/edit.svg" alt="img"></button>
                            <button class="btn btn-default btn-sm" onclick="deleteData('${row.id_device}')"><img src="assets/img/icons/delete.svg" alt="img"></button>
                            <button class="btn btn-default btn-sm" onclick="rebootESP('${row.device_id}')"><img src="assets/img/icons/transcation.svg" alt="img"></button>
                        </td>
                    </tr>
                `;
                tbody.append(tr);
            });
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function editData(id) {
    $.ajax({
        url: `/device/getData/${id}`,
        method: 'GET',
        success: function(response) {
            $('#id').val(response.id);
            $('#device_id').val(response.device_id);
            $('#formModal').modal('show');
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            toastr.error('Gagal Load Data', 'Error'); // Pesan peringatan
        }
    });
}

function deleteData(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        $.ajax({
            url: `/device/delete/${id}`,
            method: 'DELETE',
            success: function(response) {
                toastr.success(response.message, 'Success'); // Pesan sukses
                loadData(); // Refresh data setelah dihapus
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                toastr.error(response.message, 'Error'); // Pesan peringatan
            }
        });
    }
} 


function rebootESP(deviceId) {
            $.post('/device/reboot', { device_id: deviceId }, function(response) {
                alert(response.message);
                loadData();
            }).fail(function(error) {
                alert('Gagal reboot: ' + error.responseJSON.message);
            });
        }
</script>