<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Preview Absensi</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Preview Absensi</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class='table  datanew' id='dataTable'>
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Lengkap</th>
                                        <th>Waktu Masuk</th>
                                        <th>Waktu Pulang</th>
                                        <th>Keterangan</th>
                                        <th>Device Id</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    foreach ($absen as $row) {
                                        echo "
                                              <tr>
                                              <td>" . $no++ . "</td>
                                              <td>" . $row['nama_lengkap'] . "</td>
                                              <td>" . $row['jam_masuk'] . "</td>
                                              <td>" . $row['jam_pulang'] . "</td>
                                              <td>" . $row['ket'] . "</td>
                                              <td>" . $row['device_id'] . "</td>
                                              </tr>
                                              ";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="card">
                    <div class="card-body text-center">
                        <h1 id="clock" class="fw-bold"></h1>
                        <h3 id="date" class="mt-2"></h3>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title text-center">Setting Waktu Absen</h5>
                        <div class="table-responsive">
                            <table class="table" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Status Hari</th>
                                        <th>Waktu Masuk</th>
                                        <th>Waktu Pulang</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php foreach ($waktu as $wkt): ?>
                                        <tr>
                                            <td><?= $wkt['status_hari']; ?></td>
                                            <td><?= $wkt['jam_masuk']; ?></td>
                                            <td><?= $wkt['jam_pulang']; ?></td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button type="button" class="btn btn-default btn-edit" data-id="<?= $wkt['id_set'] ?>"><img src="assets/img/icons/edit.svg" alt="img"></button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Kelas</h1>
                <button type="button" class="btn btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formData">
                    <input type="hidden" name="id_set" id="id">
                    <div class="mb-3">
                        <label for="tahun_pelajaran" class="form-label">Jam Masuk</label>
                        <input type="time" class="form-control" id="jam_masuk" name="jam_masuk" id="input-pickuptime" min="00:00" max="23:59" required>
                    </div>
                    <div class="mb-3">
                        <label for="tahun_pelajaran" class="form-label">Jam Pulang</label>
                        <input type="time" class="form-control" id="jam_pulang" name="jam_pulang" id="input-pickuptime" min="00:00" max="23:59" required>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status Hari</label>
                        <select class="form-control" id="status_hari" name="status_hari">
                            <option value="Umum">Umum</option>
                            <option value="Jumat">Jumat</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success align-right btn-sm">Save</button>
                    <button type="button" class="btn btn-secondary align-right btn-sm" data-bs-dismiss="modal">Close</button>
                </form>
            </div>
        </div>
    </div>
</div>


<?= $this->endSection() ?>