<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="row">
            <div class="col">
                <h3 class="page-title"><b>Selamat Datang <?= $nama_lengkap; ?></b></h3>

            </div>

            <div class="col-lg-12">
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Aplikasi Absensi Sekolah!</strong> Aplikasi ini sebagai Tool digital pembantu dalam proses absensi dan kedispinan Sekolah. Halaman ini untuk melihat statistik dan status absensi.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            </div>


            <div class="col-lg-3 col-sm-6 col-12 d-flex">
                <div class="dash-count">
                    <div class="dash-counts">
                        <h4><?= $jurusan['nama_jurusan'] ?></h4>
                        <h5>Jurusan</h5>
                    </div>
                    <div class="dash-imgs">
                        <i data-feather="user"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12 d-flex">
                <div class="dash-count das1">
                    <div class="dash-counts">
                        <h4><?= $kelas['nama_kelas'] ?></h4>
                        <h5>Kelas</h5>
                    </div>
                    <div class="dash-imgs">
                        <i data-feather="user-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12 d-flex">
                <div class="dash-count das2">
                    <div class="dash-counts">
                        <h4><?= $rombel['nama_rombel'] ?></h4>
                        <h5>Rombel</h5>
                    </div>
                    <div class="dash-imgs">
                        <i data-feather="file-text"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12 d-flex">
                <div class="dash-count das3">
                    <div class="dash-counts">
                        <h4><?= $tp['tahun_pelajaran'] ?></h4>
                        <h5>Tahun Pelajaran</h5>
                    </div>
                    <div class="dash-imgs">
                        <i data-feather="file"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-7 col-sm-12 col-12 d-flex">
                <div class="card flex-fill">
                    <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Jadwal hari ini</h5>

                    </div>
                    <div class="card-body">
                        <table class="table datatable ">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Guru</th>
                                    <th>Nama Guru</th>
                                    <th>Jml Jam</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1;
                                foreach ($jadwal as $row_jadwal): ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= $row_jadwal['kode_guru'] ?></td>
                                        <td><?= $row_jadwal['kode_guru'] ?></td>
                                        <td><?= $row_jadwal['jumlah'] ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-sm-12 col-12 d-flex">
                <div class="card flex-fill">
                    <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Log Absen</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive dataview">
                            <table class="table datatable ">
                                <thead>
                                    <tr>
                                        <th>Key</th>
                                        <th>Nama Lengkap</th>
                                        <th>Jam Masuk</th>
                                        <th>Jam Pulang</th>
                                        <th>Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php foreach ($absen as $row): ?>
                                        <tr>
                                            <td><?= $row['key'] ?></td>
                                            <td><?= $row['nama_lengkap'] ?></td>
                                            <td><?= $row['jam_masuk'] ?></td>
                                            <td><?= $row['jam_pulang'] ?></td>
                                            <td><?= $row['ket'] ?></td>
                                        </tr>
                                    <?php endforeach; ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>