<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Data User</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Data User</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group">
                            <button class="btn btn-success btn-sm"  id="btn-add"><i class="fa fa-plus"></i> Tambah Data</button>
                            <button class="btn btn-primary btn-sm" onclick="showExcelImportModal()"><i class="fa fa-upload"></i> Import Data</button>
                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#exampleModal"><i class="fa fa-download"></i> Export Data</button>
                        </div>
                        <div class="table-responsive">
                            <table class="table  datanew ">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Lengkap</th>
                                        <th>Akses</th>
                                        <th>Rombel</th>
                                        <th>Username</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $no=1; foreach ($data as $row): ?>
                                   <tr>
                                    <td><?= $no++; ?></td>
                                    <td><?= $row['nama_lengkap']; ?></td>
                                    <td><?= $row['akses']; ?></td>
                                    <td><?= $row['nama_rombel']; ?></td>
                                    <td><?= $row['username']; ?></td>
                                    <td>
                                            <?php if ($row['status'] == 'active') { ?>
                                                <span class="badges bg-lightgreen">Active</span>
                                            <?php }else{ ?>
                                                <span class="badges bg-lightred">Inctive</span>
                                            <?php } ?>
                                        </td>
                                    <td>
                                    <div class="btn-group btn-group-sm">
                                            <button class="btn btn-default btn-sm" onclick="editData('<?= $row['id_user'] ?>')"><img src="assets/img/icons/edit.svg" alt="img"></button>
                                            <button class="btn btn-default btn-sm" onclick="deleteData('<?= $row['id_user'] ?>')"><img src="assets/img/icons/delete.svg" alt="img"></button>
                                            </div>
                                    </td>
                                   </tr>
                                  <?php endforeach; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Data User</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <form id="formData">
                <input type="hidden" name="id_user" id="id">
                <div class="row">
                    <div class="col-sm-6">
                    <div class="mb-3">
                        <label  class="form-label">Nama Lengkap</label>
                        <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" placeholder="20xxx"  required>
                    </div>
                    <div class="mb-3">
                        <label  class="form-label">Akses</label>
                        <select class="form-control" id="akses" name="akses" >
                            <option value="">Pilih Data</option>
                            <option value="walikelas">Walikelas</option>
                            <option value="piket">Piket</option>
                            <option value="admin">Admin</option>
                        </select>
                    </div>  
                    <div class="mb-3">
                        <label  class="form-label">Rombel</label>
                        <select class="form-control" id="rombel" name="rombel" disabled>
                            <option value="">Pilih Data</option>
                            <?php foreach ($rombel as $r): ?>
                                <option value="<?= $r['id_rombel']?>"><?= $r['nama_rombel']?></option>
                                <?php endforeach; ?>
                        </select>
                    </div>  
                       
                    </div>
                    <div class="col-sm-6">
                    <div class="mb-3">
                        <label  class="form-label">Username</label>
                        <input type="text" class="form-control" id="username" name="username" placeholder="adaXX"  required>
                    </div>
                    <div class="mb-3">
                        <label  class="form-label">Password</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="****" >
                    </div>     
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>                        
                    </div>
                </div>
            </div>
            <div class="modal-footer">
            <button type="submit" class="btn btn-success btn-sm">Save</button>
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="import" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Data dari Excel</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="excelFile" class="form-label">Pilih File Excel</label>
                    <input type="file" id="excelFile" class="form-control" accept=".xls,.xlsx">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button class="btn btn-primary" onclick="importXls()">Upload</button>
            </div>
        </div>
    </div>
</div>


<?= $this->endSection() ?>