<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Data Tahun Ajaran</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Data Tahun Ajaran</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group">
                            <button class="btn btn-success btn-sm" id="btn-add"><i class="fa fa-plus"></i> Tambah Data</button>
                        </div>
                        <div class="table-responsive">
                        <table class="table datanew dataTable no-footer" id="example" role="grid" aria-describedby="DataTables_Table_0_info">
                            <!-- <table class="table  datanew dataTable" id="dataTable"> -->
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Tahun Ajaran</th>
                                        <th>Semester Aktif</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no=1; foreach ($data as $row): ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= $row['tahun_pelajaran'] ?></td>
                                        <td><?= $row['semester_aktif'] ?></td>
                                        <td>
                                            <?php if ($row['status'] == 'active') { ?>
                                                <span class="badges bg-lightgreen">Active</span>
                                            <?php }else{ ?>
                                                <span class="badges bg-lightred">Inctive</span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <button type="button" class="btn btn-default btn-edit" data-id="<?= $row['id_tahun'] ?>"><img src="assets/img/icons/edit.svg" alt="img"></button>
                                                <button type="button" class="btn btn-default btn-delete" data-id="<?= $row['id_tahun'] ?>"><img src="assets/img/icons/delete.svg" alt="img"></button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach ?>


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Tahun Pelajaran</h1>
                <button type="button" class="btn btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formData">
                    <input type="hidden" name="id_tahun" id="id_tahun">
                    <div class="mb-3">
                        <label for="tahun_pelajaran" class="form-label">Tahun Pelajaran</label>
                        <input type="text" class="form-control" id="tahun_pelajaran" name="tahun_pelajaran" placeholder="2020/2021" required>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="semester_aktif" class="form-label">Semester Aktif</label>
                        <input type="text" class="form-control" id="semester_aktif" name="semester_aktif" placeholder="1" required>
                    </div>
                    <button type="submit" class="btn btn-success align-right btn-sm">Save</button>
                    <button type="button" class="btn btn-secondary align-right btn-sm" data-bs-dismiss="modal">Close</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>