<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Data Rombel</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Data Rombel</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group">
                            <button class="btn btn-success btn-sm" id="btn-add"><i class="fa fa-plus"></i> Tambah Data</button>
                        </div>
                        <div class="table-responsive">
                        <table class="table  datanew " id="dataTable">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode Rombel</th>
                                        <th>Nama Rombel</th>
                                        <th>Kelas</th>
                                        <th>Jurusan</th>
                                        <th>Tahun Pelajaran</th>
                                        <th>Ruangan</th>
                                        <th>Wali Kelas</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $no=1; foreach ($rombel as $row): ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= $row['kode_rombel'] ?></td>
                                        <td><?= $row['nama_rombel'] ?></td>
                                        <td><?= $row['nama_kelas'] ?></td>
                                        <td><?= $row['nama_jurusan'] ?></td>
                                        <td><?= $row['tahun_pelajaran'] ?></td>
                                        <td><?= $row['ruangan'] ?></td>
                                        <td><?= $row['walikelas'] ?></td>
                                        <td>
                                            <?php if ($row['status'] == 'active') { ?>
                                                <span class="badges bg-lightgreen">Active</span>
                                            <?php }else{ ?>
                                                <span class="badges bg-lightred">Inctive</span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                            <button class="btn btn-default btn-sm" onclick="editData('<?= $row['id_rombel'] ?>')"><img src="assets/img/icons/edit.svg" alt="img"></button>
                                            <button class="btn btn-default btn-sm" onclick="deleteData('<?= $row['id_rombel'] ?>')"><img src="assets/img/icons/delete.svg" alt="img"></button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Kelas</h1>
                <button type="button" class="btn btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formData">
                <input type="hidden" name="kode_kelas" id="id">
                <div class="row"> 
                                <div class="col-sm-6">
                                <div class="mb-3">
                        <label for="kode_rombel" class="form-label">Kode Rombel</label>
                        <input type="text" class="form-control" id="kode_rombel" name="kode_rombel" placeholder="KELAS_XI"  required>
                    </div>
                    <div class="mb-3">
                        <label for="nama_rombel" class="form-label">Nama Rombel</label>
                        <input type="text" class="form-control" id="nama_rombel" name="nama_rombel" placeholder="TKJ 1"  required>
                    </div>
                    <div class="mb-3">
                        <label for="kelas" class="form-label">Kelas</label>
                        <select class="form-control" id="kode_kelas" name="kode_kelas">
                            <option value="">Pilih Kelas</option>
                            <?php foreach ($kelas as $kls) { ?>
                                <option value="<?= $kls['kode_kelas'] ?>"><?= $kls['nama_kelas'] ?></option>
                            <?php } ?>
                        </select>
                        </div>
                        <div class="mb-3">
                        <label for="walikelas" class="form-label">Walikelas</label>
                        <input type="text" class="form-control" id="walikelas" name="walikelas" placeholder="Agus" required>
                    </div>
                                </div>
                                <div class="col-sm-6">
                                <div class="mb-3">
                        <label for="jurusan" class="form-label">Jurusan</label>
                        <select class="form-control" id="kode_jurusan" name="kode_jurusan">
                            <option value="">Pilih Jurusan</option>
                            <?php foreach ($jurusan as $jrs) { ?>
                                <option value="<?= $jrs['kode_jurusan'] ?>"><?= $jrs['nama_jurusan'] ?></option>
                            <?php } ?>
                        </select>
                        </div>
                    <div class="mb-3">
                        <label for="ruangan" class="form-label">Ruangan</label>
                        <input type="text" class="form-control" id="ruangan" name="ruangan" placeholder="21" required>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
</div>
                </div>
                    <button type="submit" class="btn btn-success align-right btn-sm">Save</button>
                    <button type="button" class="btn btn-secondary align-right btn-sm" data-bs-dismiss="modal">Close</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>