<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Data Peserta Didik</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Data Peserta Didik</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group">
                            <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#exampleModal"><i class="fa fa-plus"></i> Tambah Data</button>
                            <button class="btn btn-primary btn-sm" onclick="showExcelImportModal()"><i class="fa fa-upload"></i> Import Data</button>
                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#exampleModal"><i class="fa fa-download"></i> Export Data</button>
                        </div>
                        <div class="table-responsive">
                            <table class="table  datanew ">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>NIS</th>
                                        <th>Nama Lengkap</th>
                                        <th>JK</th>
                                        <th>Jurusan</th>
                                        <th>Kelas</th>
                                        <th>Rombel</th>
                                        <th>status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $no=1; foreach ($data as $row): ?>
                                   <tr>
                                    <td><?= $no++; ?></td>
                                    <td><?= $row['nisn']; ?></td>
                                    <td><?= $row['nama_lengkap']; ?></td>
                                    <td><?= $row['jk']; ?></td>
                                    <td><?= $row['nama_jurusan']; ?></td>
                                    <td><?= $row['nama_kelas']; ?></td>
                                    <td><?= $row['nama_rombel']; ?></td>
                                    <td>
                                            <?php if ($row['status_pd'] == 'aktif') { ?>
                                                <span class="badges bg-lightgreen">Active</span>
                                            <?php }else{ ?>
                                                <span class="badges bg-lightred">Inctive</span>
                                            <?php } ?>
                                        </td>
                                    <td>
                                    <div class="btn-group btn-group-sm">
                                            <button class="btn btn-default btn-sm" onclick="viewData('<?= $row['id_pd'] ?>')"><img src="assets/img/icons/eye.svg" alt="img"></button>
                                            <button class="btn btn-default btn-sm" onclick="editData('<?= $row['id_pd'] ?>')"><img src="assets/img/icons/edit.svg" alt="img"></button>
                                            <button class="btn btn-default btn-sm" onclick="deleteData('<?= $row['id_pd'] ?>')"><img src="assets/img/icons/delete.svg" alt="img"></button>
                                            </div>
                                    </td>
                                   </tr>
                                  <?php endforeach; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Data Peserta Didik</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formData">
                <input type="hidden" name="id_pd" id="id">
            <div class='row'>
                    <div class='col-12'>
                    <table class='table' width='100%'>
                         <tr>
                    <th colspan='6'><b>A. Identitas / Data Diri</b></th>
                </tr>
                <tr>
                    <td width='10%'>NISN</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="nisn" id="nisn" required></td>
                    <td width='10%'>Nama Lengkap</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="nama_lengkap" id="nama_lengkap" required></td>
                </tr>
                <tr>
                    <td width='10%'>Tempat Lahir</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="tmp_lahir" id="tmp_lahir" required></td>
                    <td width='10%'>Tanggal Lahir</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="date" name="tgl_lahir" id="tgl_lahir" required></td>
                </tr>
                <tr>
                    <td width='10%'>Jenis Kelamin</td>
                    <td width='20'>:</td>
                    <td>
                    <select class="form-control" id="jk" name="jk">
                            <option value="">Pilih Data</option>
                            <option value="L">Laki-Laki</option>
                            <option value="P">Perempuan</option>
                        </select>
                    </td>
                    <td width='10%'>Alamat</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="alamat" id="alamat" required></td>
                </tr>
                <tr>
                    <td width='10%'>Email</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="email" id="email" required></td>
                    <td width='10%'>No HP</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="no_hp" id="no_hp" required></td>
                </tr>
                <tr>
                    <th width='20%' colspan='6'><b>B. Orang Tua / Wali</b></th>
                </tr>
                <tr>
                    <td width='10%'>Nama Ayah</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="nama_ayah" id="nama_ayah" required></td>
                    <td width='10%'>No HP</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="no_hp_ayah" id="no_hp_ayah" required></td>
                </tr>
                <tr>
                    <td width='10%'>Nama Ibu</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="nama_ibu" id="nama_ibu" required></td>
                    <td width='10%'>No Hp</td>
                    <td width='20'>:</td>
                    <td width='40%'><input class="form-control" type="text" name="no_hp_ibu" id="no_hp_ibu" required></td>
                </tr>
                <tr>
                    <td width='10%'>Nama Wali</td>
                    <td width='20'>:</td>
                    <td></td>
                    <td width='10%'>No Hp</td>
                    <td width='20'>:</td>
                    <td></td>
                </tr>
                <tr>
                            <td colspan='6'><b>C. Informasi Akademik</b></td>
                        </tr>
                        <tr>
                            <td width='10%'>Jurusan</td>
                            <td width='20'>:</td>
                            <td width='10%'>
                            <select class="form-control" id="kode_jurusan" name="kode_jurusan">
                            <option value="">Pilih Data</option>
                            <?php foreach ($jurusan as $jur): ?>
                                <option value="<?= $jur['kode_jurusan']?>"><?= $jur['nama_jurusan']?></option>
                            <?php endforeach;?>
                        </select>
                            </td>
                            <td width='10%'>Kelas</td>
                            <td width='20'>:</td>
                            <td width='10%'>
                            <select class="form-control" id="kode_kelas" name="kode_kelas">
                            <option value="">Pilih Data</option>
                            <?php foreach ($kelas as $kel): ?>
                                <option value="<?= $kel['kode_kelas']?>"><?= $kel['nama_kelas']?></option>
                            <?php endforeach;?>
                        </select>
                            </td>
                        </tr>
                       
                        <tr>
                            <td width='10%'>Rombel</td>
                            <td width='20'>:</td>
                            <td width='10%'>
                            <select class="form-control" id="kode_rombel" name="kode_rombel">
                            <option value="">Pilih Data</option>
                            <?php foreach ($rombel as $rom): ?>
                                <option value="<?= $rom['kode_rombel']?>"><?= $rom['nama_rombel']?></option>
                            <?php endforeach;?>
                        </select>
                            </td>
                        <td width='10%'>Tahun Pelajaran Aktif</td>
                            <td width='20'>:</td>
                            <td width='10%'><input class="form-control" type="text"  id="tahun_pelajaran" readonly></td>
                    
                        </tr>
                        <tr>
                            <td width='10%'>Semester</td>
                            <td width='20'>:</td>
                            <td width='10%'><input class="form-control" type="text"  id="semester_aktif" readonly></td>
                            <td width='10%'>Status</td>
                            <td width='20'>:</td>
                            <td width='10%'>
                            <select class="form-control" id="status" name="status">
                            <option value="">Pilih Data</option>
                            <option value="aktif">Aktif</option>
                            <option value="pindah">Pindah</option>
                            <option value="keluar">Keluar</option>
                            <option value="lulus">Lulus</option>
                        </select>
                            </td>
                        </tr>
                        <tr>
                            <td width='10%'>Password</td>
                            <td width='20'>:</td>
                            <td width='10%'><input class="form-control" type="password"  id="password" ></td>
                           
                        </tr>
               </table>
                    </div>
                    
                </div>
                                          
            </div>
            <div class="modal-footer">
            <button type="submit" class="btn btn-success btn-sm">Save</button>
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
            </form>      
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="view" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Detail Data Peserta Didik</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="dataview"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="import" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Data dari Excel</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="excelFile" class="form-label">Pilih File Excel</label>
                    <input type="file" id="excelFile" class="form-control" accept=".xls,.xlsx">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button class="btn btn-primary" onclick="importXls()">Upload</button>
            </div>
        </div>
    </div>
</div>


<?= $this->endSection() ?>