<?= $this->extend('template') ?>
<?= $this->section('content') ?>


<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col">
                    <h3 class="page-title">Data Mata Pelajaran</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Easy App</a></li>
                        <li class="breadcrumb-item active">Data Mata Pelajaran</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="btn-group">
                            <button class="btn btn-success btn-sm" id="btn-add"><i class="fa fa-plus"></i> Tambah Data</button>
                            <button class="btn btn-success btn-sm" onclick="showExcelImportModal()">Import Data (Excel)</button>

                        </div>
                        <div class="table-responsive">
                            <table class="table  datanew" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode Mapel</th>
                                        <th>Nama Mata Pelajaran</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Form Mata Pelajaran</h1>
                <button type="button" class="btn btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formData">
                    <input type="hidden" name="id" id="id">
                    <div class="mb-3">
                        <label for="kd_mapel" class="form-label">Kode Mata Pelajaran</label>
                        <input type="text" class="form-control" id="kd_mapel" name="kd_mapel" placeholder="BIND" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="nama_mapel" class="form-label">Nama Mata Pelajaran</label>
                        <input type="text" class="form-control" id="nama_mapel" name="nama_mapel" placeholder="Bahasa Inggris" required>
                    </div>
                    <button type="submit" class="btn btn-success align-right btn-sm">Save</button>
                    <button type="button" class="btn btn-secondary align-right btn-sm" data-bs-dismiss="modal">Close</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="excelImportModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Data dari Excel</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="excelFile" class="form-label">Pilih File Excel</label>
                    <input type="file" id="excelFile" class="form-control" accept=".xls,.xlsx">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button class="btn btn-primary" onclick="importXls()">Upload</button>
            </div>
        </div>
    </div>
</div>





<?= $this->endSection() ?>