<?php namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
	protected $table      = 'user';
	protected $primaryKey = 'id_user';

	protected $useSoftDeletes = false;
    protected $useTimestamps = false; // Matikan fitur timestamps jika tidak ada kolom created_at/updated_at
	protected $allowedFields = [
        'nama_lengkap',
        'status',
        'username',
        'password',
        'foto',
        'akses',
        'id_rombel',
        ];

        // Mengambil data user dengan join ke tbl_rombel
    public function getUsersWithRombel()
    {
        return $this->select('user.*, tbl_rombel.nama_rombel')
                    ->join('tbl_rombel', 'user.id_rombel = tbl_rombel.id_rombel', 'left')
                    ->findAll();
    }

    // Mengambil satu user berdasarkan ID dengan join ke tbl_rombel
    public function getUserById($id)
    {
        return $this->select('user.*, tbl_rombel.nama_rombel')
                    ->join('tbl_rombel', 'user.id_rombel = tbl_rombel.id_rombel', 'left')
                    ->where('user.id_user', $id)
                    ->first();
    }
}

?>