<?php namespace App\Models;

use CodeIgniter\Model;

class RombelModel extends Model
{
	protected $table      = 'tbl_rombel';
	protected $primaryKey = 'id_rombel';

	protected $useSoftDeletes = false;
	protected $useTimestamps = false; // Matikan fitur timestamps jika tidak ada kolom created_at/updated_at
	protected $allowedFields = ['kode_rombel','nama_rombel','ruangan','kode_kelas','kode_jurusan','id_tahun_pelajaran','walikelas','status'];

	public function getRombelData()
    {
        // Query SQL sesuai dengan yang Anda berikan
        $builder = $this->db->table(tableName: 'tbl_rombel');
        $builder->select('tbl_jurusan.nama_jurusan, tbl_kelas.nama_kelas, tbl_tahun_pelajaran.tahun_pelajaran, tbl_rombel.nama_rombel, tbl_rombel.status, tbl_rombel.kode_kelas, tbl_rombel.kode_jurusan, tbl_rombel.id_tahun_pelajaran, tbl_rombel.kode_rombel, tbl_rombel.ruangan, tbl_rombel.id_rombel, tbl_rombel.walikelas');
        $builder->join('tbl_jurusan', 'tbl_rombel.kode_jurusan = tbl_jurusan.kode_jurusan', 'left');
        $builder->join('tbl_kelas', 'tbl_rombel.kode_kelas = tbl_kelas.kode_kelas', 'left');
        $builder->join('tbl_tahun_pelajaran', 'tbl_rombel.id_tahun_pelajaran = tbl_tahun_pelajaran.id_tahun', 'left');
        $builder->where('tbl_tahun_pelajaran.status', 'active');
        return $builder->get()->getResultArray(); // Mengambil hasil dalam bentuk array
    }

    public function getRombelKodeKelas(string $kode_kelas)
    {
        $id_tahun = tahun_pelajaran_aktif();
        $query = $this->table('tbl_rombel')
        ->select('*')
        ->where('kode_kelas', $kode_kelas)
        ->where('id_tahun_pelajaran',  $id_tahun);;
    
    // echo $query->getLastQuery()->getQuery(); // Debugging query
    return $query->findAll();
    }

    public function CountRombelKodeKelas(string $kode_kelas)
    {
        $id_tahun = tahun_pelajaran_aktif();
        $query = $this->table('tbl_rombel')
        ->select('*')
        ->where('kode_kelas', $kode_kelas)
        ->where('id_tahun_pelajaran',  $id_tahun);
    
    // echo $query->getLastQuery()->getQuery(); // Debugging query
    return $query->countAll();
    }

}

?>