<?php

namespace App\Models;

use CodeIgniter\Model;

class PesertaDidikModel extends Model
{
    protected $table      = 'tbl_master_pd';
    protected $primaryKey = 'id_pd';
    protected $useSoftDeletes = false;
    protected $useTimestamps = false; // Matikan fitur timestamps jika tidak ada kolom created_at/updated_at

    protected $allowedFields = [
        'nis',
        'nik',
        'nama_lengkap',
        'tmp_lahir',
        'tgl_lahir',
        'jk',
        'gol_darah',
        'agama',
        'tinggi_badan',
        'berat_badan',
        'no_skhu',
        'id_provinsi',
        'id_kecamatan',
        'id_kabupaten',
        'desa',
        'alamat',
        'email',
        'rt',
        'rw',
        'kd_pos',
        'no_hp',
        'npsn',
        'nama_sekolah',
        'id_provinsi_sekolah',
        'id_kabupaten_sekolah',
        'id_kecamatan_sekolah',
        'alamat_sekolah',
        'nama_ayah',
        'id_pekerjaan_ayah',
        'id_penghasilan_ayah',
        'status_hidup_ayah',
        'id_pendidikan_ayah',
        'no_hp_ayah',
        'nama_ibu',
        'id_pekerjaan_ibu',
        'id_penghasilan_ibu',
        'status_hidup_ibu',
        'id_pendidikan_ibu',
        'no_hp_ibu',
        'id_jurusan',
        'id_periode',
        'tgl_daftar',
        'validasi_peserta',
        'jml_pembayaran',
        'status_pembayaran',
        'penerima_pembayaran',
        'tgl_pembayaran',
        'anak_ke',
        'jml_saudara',
        'penerima_kip',
        'nomor_kipkpspkh',
        'eskul',
        'tmp_lahir_ibu',
        'tgl_lahir_ibu',
        'tmp_lahir_ayah',
        'tgl_lahir_ayah',
        'nisn',
        'no_ijazah',
        'no_un',
        'nama_wali',
        'id_pekerjaan_wali',
        'alamat_orangtua',
        'rt_orangtua',
        'rw_orangtua',
        'status_awal',
        'asal_sekolah_pindah',
        'alamat_sekolah_pindah',
        'kelas_pindah',
        'pilih_wali',
        'nm_wali',
        'no_hp_wali',
        'status_pd',
        'angkatan',
        'kode_kelas',
        'kode_jurusan',
        'kode_rombel',
        'id_tahun',
        'key',
        'password'
    ];


    public function getDataView()
    {
        return $this->select(
            'tbl_kelas.nama_kelas, tbl_jurusan.nama_jurusan, tbl_rombel.nama_rombel, 
             tbl_master_pd.kode_rombel, tbl_master_pd.kode_jurusan, tbl_master_pd.kode_kelas, 
             tbl_master_pd.nisn, tbl_master_pd.id_pd, tbl_master_pd.nama_lengkap, tbl_master_pd.key,
             tbl_master_pd.jk, tbl_master_pd.status_pd'
        )
            ->join('tbl_kelas', 'tbl_master_pd.kode_kelas = tbl_kelas.kode_kelas', 'left')
            ->join('tbl_jurusan', 'tbl_master_pd.kode_jurusan = tbl_jurusan.kode_jurusan', 'left')
            ->join('tbl_rombel', 'tbl_master_pd.kode_rombel = tbl_rombel.kode_rombel', 'left')
            ->findAll();
    }



    public function getDataCard()
    {
        return $this->select(
            'tbl_kelas.nama_kelas, tbl_jurusan.nama_jurusan, tbl_rombel.nama_rombel, 
             tbl_master_pd.kode_rombel, tbl_master_pd.kode_jurusan, tbl_master_pd.kode_kelas, 
             tbl_master_pd.nisn, tbl_master_pd.id_pd, tbl_master_pd.nama_lengkap, tbl_master_pd.key,
             tbl_master_pd.jk, tbl_master_pd.status_pd'
        )
            ->join('tbl_kelas', 'tbl_master_pd.kode_kelas = tbl_kelas.kode_kelas', 'left')
            ->join('tbl_jurusan', 'tbl_master_pd.kode_jurusan = tbl_jurusan.kode_jurusan', 'left')
            ->join('tbl_rombel', 'tbl_master_pd.kode_rombel = tbl_rombel.kode_rombel', 'left')
            ->orderBy('key', 'asc')
            ->findAll();
    }



    public function getDataViewDetail($id)
    {
        return $this->select(
            'tbl_kelas.nama_kelas, 
					tbl_jurusan.nama_jurusan, 
					tbl_rombel.nama_rombel, 
					tbl_master_pd.kode_rombel, 
					tbl_master_pd.kode_jurusan, 
					tbl_master_pd.kode_kelas, 
					tbl_master_pd.nisn, 
					tbl_master_pd.id_pd, 
					tbl_master_pd.nama_lengkap, 
					tbl_master_pd.jk, 
					tbl_master_pd.status_pd, 
					tbl_master_pd.tmp_lahir, 
					tbl_master_pd.tgl_lahir, 
					tbl_master_pd.alamat, 
					tbl_master_pd.email, 
					tbl_master_pd.no_hp, 
					tbl_master_pd.nama_ayah, 
					tbl_master_pd.nama_ibu, 
					tbl_master_pd.no_hp_ayah, 
					tbl_master_pd.no_hp_ibu, 
					tbl_master_pd.nama_wali, 
					tbl_master_pd.no_hp_wali, 
					tbl_master_pd.`key`, 
					tbl_master_pd.`password`, 
					tbl_tahun_pelajaran.tahun_pelajaran, 
					tbl_tahun_pelajaran.semester_aktif, 
					tbl_master_pd.id_tahun'
        )
            ->join('tbl_kelas', 'tbl_master_pd.kode_kelas = tbl_kelas.kode_kelas', 'left')
            ->join('tbl_jurusan', 'tbl_master_pd.kode_jurusan = tbl_jurusan.kode_jurusan', 'left')
            ->join('tbl_rombel', 'tbl_master_pd.kode_rombel = tbl_rombel.kode_rombel', 'left')
            ->join('tbl_tahun_pelajaran', 'tbl_master_pd.id_tahun = tbl_tahun_pelajaran.id_tahun', 'left')
            ->where('tbl_master_pd.id_pd', $id)
            ->findAll();
    }
}
