<?php

namespace App\Models;

use CodeIgniter\Model;

class JadwalModel extends Model
{
    protected $table      = 'tbl_jadwal';
    protected $primaryKey = 'id_jadwal';

    protected $useSoftDeletes = false;
    protected $useTimestamps = false; // Matikan fitur timestamps jika tidak ada kolom created_at/updated_at

    protected $allowedFields = [
        'id_tahun',
        'kelas',
        'kd_mapel',
        'id_gtk',
        'durasi',
        'ruangan',
        'semester',
        'hari',
        'id_rombel',
        'jam_ke',
        'kode_rombel',
        'kode_guru',

    ];

    public function getJadwalByHari($hari, $id_tahun)
    {
        return $this->select('tbl_rombel.nama_rombel, tbl_jadwal.kode_rombel, tbl_jadwal.kode_guru, tbl_gtk.nama_lengkap, tbl_jadwal.id_tahun, tbl_jadwal.jam_ke, tbl_jadwal.hari')
            ->join('tbl_rombel', 'tbl_jadwal.kode_rombel = tbl_rombel.kode_kelas', 'left')
            ->join('tbl_gtk', 'tbl_jadwal.kode_guru = tbl_gtk.kode_guru', 'left')
            ->join('tbl_tahun_pelajaran', 'tbl_jadwal.id_tahun = tbl_tahun_pelajaran.id_tahun', 'left')
            ->where('tbl_jadwal.hari', $hari)
            ->where('tbl_jadwal.id_tahun', $id_tahun)
            ->findAll();
    }
    public function getJadwalByHariGtk($hari, $id_tahun, $kode_guru)
    {
        return $this->select('*')
            ->join('tbl_rombel', 'tbl_jadwal.kode_rombel = tbl_rombel.kode_rombel', 'left')
            ->join('tbl_tahun_pelajaran', 'tbl_jadwal.id_tahun = tbl_tahun_pelajaran.id_tahun', 'left')
            ->where('tbl_jadwal.hari', $hari)
            ->where('tbl_jadwal.kode_guru', $kode_guru)
            ->where('tbl_jadwal.id_tahun', $id_tahun)
            ->findAll();
    }

    function getRekapJadwalbyRombel($hari, $id_tahun, $kode_guru)
    {
        return $this->select('MIN(id_jadwal) as id_jadwal, kode_guru,ruangan, kode_rombel, hari, COUNT(*) as jumlah')
            ->groupBy(['kode_guru', 'hari', 'ruangan', 'kode_rombel'])
            ->orderBy('kode_rombel', 'asc')
            ->where('hari', $hari)
            ->where('id_tahun', $id_tahun)
            ->where('kode_guru', $kode_guru)
            ->findAll();
    }

    function getRekapJadwalbyHariPd($hari, $rombel)
    {
        return $this->select('MIN(id_jadwal) as id_jadwal, kode_guru,ruangan, kode_rombel, hari, COUNT(*) as jumlah')
            ->groupBy(['kode_guru', 'hari', 'ruangan', 'kode_rombel'])
            ->orderBy('kode_rombel', 'asc')
            ->where('hari', $hari)
            ->where('kode_rombel', $rombel)
            ->findAll();
    }

    public function getJadwalByHariPd($hari, $rombel, $id_tahun)
    {
        return $this->select('*')
            ->join('tbl_rombel', 'tbl_jadwal.kode_rombel = tbl_rombel.kode_rombel', 'left')
            ->join('tbl_tahun_pelajaran', 'tbl_jadwal.id_tahun = tbl_tahun_pelajaran.id_tahun', 'left')
            ->join('tbl_gtk', 'tbl_jadwal.kode_guru = tbl_gtk.kode_guru', 'left')
            ->where('tbl_jadwal.hari', $hari)
            ->where('tbl_jadwal.kode_rombel', $rombel)
            ->where('tbl_jadwal.id_tahun', $id_tahun)
            ->findAll();
    }
}
