<?php namespace App\Models;

use CodeIgniter\Model;

class DurasiModel extends Model
{
	protected $table      = 'tbl_durasi_belajar';
	protected $primaryKey = 'id_waktu';

	protected $useSoftDeletes = false;
	protected $useTimestamps = false; // Matikan fitur timestamps jika tidak ada kolom created_at/updated_at

	protected $allowedFields = ['jam_ke','durasi', 'status_hari'];

    function bystatusHariJumat()  {
        $query = $this->table('tbl_durasi_belajar')
        ->select('*')
        ->where('status_hari',  'Jumat');
        return $query->findAll();
    }

    function bystatusHariKBM()  {
        $query = $this->table('tbl_durasi_belajar')
        ->select('*')
        ->where('status_hari',  'KBM');
        return $query->findAll();
    }
}

?>