<?php

if (!function_exists('tahun_pelajaran_aktif')) {
    /**
     * Mendapatkan tahun pelajaran aktif
     *
     * @return string Tahun pelajaran aktif (misalnya "2024/2025")
     */
    function tahun_pelajaran_aktif()
    {
        // Simulasi mendapatkan data dari database
        // Sesuaikan dengan kebutuhan aplikasi Anda
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_tahun_pelajaran');
        
        $tahunAktif = $builder->where('status', value: 'active')->get()->getRow();
        
        if ($tahunAktif) {
            return $tahunAktif->id_tahun;
        }

        // Default jika tidak ditemukan
        return 'Tidak ada tahun pelajaran aktif';
    }
}
