<?php

namespace App\Controllers\Piket;

use App\Controllers\BaseController;
use App\Models\GtkModel;
use App\Models\JurusanModel;
use App\Models\KelasModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;

class PesertaDidik extends BaseController
{

    public function __construct() {
        $this->modelGTK = new GtkModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelRombel = new RombelModel();
        $this->modelJurusan = new JurusanModel();
        $this->modelKelas = new KelasModel();
    }
	public function index()
	{
		$data = [
			"menu" => "piket",
            "data" => $this->modelPD->getDataView(),
            "rombel" => $this->modelRombel->getRombelData(),
            "jurusan" => $this->modelJurusan->findAll(),
            "kelas" => $this->modelKelas->findAll(),
		];
		return view('piket/pesertadidik', data: $data);
	}
}
