<?php

namespace App\Controllers\Piket;

use App\Controllers\BaseController;
use App\Models\JadwalModel;
use App\Models\KelasModel;
use App\Models\DurasiModel;
use App\Models\RombelModel;
use Carbon\Carbon;

class Jadwal extends BaseController
{
    public function __construct()
    {
        $this->modelJadwal = new JadwalModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelDurasi = new DurasiModel();
    }
    public function index()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        $namaHari = $hariIndo[$hariIni];
        // $namaHari = "Senin";

        $data = [
            "menu" => "piket",
            "data" => $this->modelJadwal->getJadwalByHari($namaHari, $id_tahun),
            "rombel" => $this->modelRombel->findAll(),
            "hari" => $namaHari,
        ];
        return view('piket/jadwal', $data);
    }

    public function AllViewJadwal()
    {
        $data = [
            "menu" => "piket",
        ];
        return view('piket/previewJadwal', data: $data);
    }

    function kelasLive()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        // $namaHari = $hariIndo[$hariIni];
        $namaHari = "Senin";

        $data = [
            "menu" => "piket",
            "data" => $this->modelJadwal->getJadwalByHari($namaHari, $id_tahun),
            "rombel" => $this->modelRombel->findAll(),
            "hari" => $namaHari,
        ];
        return view('piket/kelaslive', data: $data);
    }

    function LoadAllViewJadwal()
    {
        $kelas =  $this->modelKelas->findAll();
        $jml_kelas = $this->modelKelas->countAll();
        $jml_rombel = $this->modelRombel->getRombelData();

        echo "
         <table class='table' style='width:100%; font-size:10px' >
                                <thead>
                                    <tr>
                                        <th rowspan='4' style='vertical-align:middle;'>HARI</th>
                                        <th rowspan='4' style='vertical-align:middle;'>JAM</th>
                                        <th rowspan='4' style='vertical-align:middle;'>WAKTU</th>
                                        <th colspan='" . count($jml_rombel) . "' style='text-align:center'>KELAS</th>
                                    </tr><tr>";
        // $Rkel = array();
        foreach ($kelas as $kel) {
            $jml_rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            echo "
                                    <td colspan='" . count($jml_rombel) . "' align='center'>" . $kel['nama_kelas'] . "</td>
                                    ";
            // array_push($Rkel,$kel['kode_kelas']);
        }
        //    $rombel = $this->modelJadwal->getRombelKodeKelas($kel['kode_kelas']);
        echo "</tr>
                                <tr>";
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            foreach ($rombel as $rom) {
                echo "
                                        <td>" . $rom['nama_rombel'] . "</td>
                                        ";
            }
        }
        echo "</tr>
                                 <tr>";
        $no = 1;
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);

            foreach ($rombel as $rom) {
                echo "
                                        <td align='center'>" . $no++ . "</td>
                                        ";
            }
        }
        echo "</tr>
                                </thead>
                                <tbody>";
        $hari = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat'];
        $jadwal = $this->modelJadwal->findAll();
        $jml_colom = count($jml_rombel) + 4;
        $durasiJumat = $this->modelDurasi->bystatusHariJumat();
        $durasiKBM = $this->modelDurasi->bystatusHariKBM();
        if (empty($jadwal)) {
            echo "<tr>
                                    <td colspan='" . $jml_colom . "'>Data Tidak ada / Belum Digenerate</td>
                                    </tr>";
        } else {
            foreach ($hari as $h) {
                if ($h == 'Jumat') {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiJumat) . "'>" . $h . "</td>
                                           ";
                    foreach ($durasiJumat as $durJum) {
                        echo "
                                            <td align='center'>" . $durJum['jam_ke'] . "</td>
                                            <td align='center'>" . $durJum['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durJum['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();


                                echo "
                                                    <td>" . $jadwal['kode_guru'] . "</td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                } else {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiKBM) . "'>" . $h . "</td> ";
                    foreach ($durasiKBM as $durKBM) {
                        echo "
                                            <td align='center'>" . $durKBM['jam_ke'] . "</td>
                                            <td align='center'>" . $durKBM['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durKBM['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();
                                echo "
                                                    <td>" . $jadwal['kode_guru'] . "</td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                }
            }
        }

        echo "
                                   <tr>
                                   <td align='center'>Ruangan</td>
                                   </tr>
                                  ";

        echo "</tbody>
                            </table>
        ";
    }
}
