<?php

namespace App\Controllers\Piket;

use App\Models\GtkModel;
use App\Models\JurusanModel;
use App\Models\TahunAjaranModel;
use App\Models\MapelModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;
use App\Models\AbsensiModel;
use App\Controllers\BaseController;

class Home extends BaseController
{

	public function __construct()
	{
		$this->session = session();
		$this->modelTahun = new TahunAjaranModel();
		$this->modelMapel = new MapelModel();
		$this->modelPD = new PesertaDidikModel();
		$this->modelRombel = new RombelModel();
		$this->modelJurusan = new JurusanModel();
		$this->modelGTK = new GtkModel();
		$this->modelAbsensi = new AbsensiModel();
	}
	public function index()
	{
		$data = [
			"menu" => "piket",
			"nama_lengkap" => $this->session->get('nama_lengkap'),
			"jml_gtk" => $this->modelGTK->countAll(),
			"jml_rombel" => $this->modelRombel->getRombelData(),
			"jml_jurusan" => $this->modelJurusan->countAll(),
			"jml_PesertaDidik" => $this->modelPD->countAll(),
		];
		return view('piket/home', $data);
	}

	public function loadAbsensi()
	{
		$tgl_sekarang = date('Y-m-d');
		$absen = $this->modelAbsensi->where('tgl_absen', $tgl_sekarang)
			->limit(10)
			->orderBy('id_absen', 'desc')
			->find();



		foreach ($absen as $row) {
			echo "
            <tr>
            <td>" . $row['key'] . "</td>
            <td>" . $row['nama_lengkap'] . "</td>
            <td>" . $row['jam_masuk'] . "</td>
            <td>" . $row['ket'] . "</td>
            </tr>
            ";
		}
	}
}
