<?php

namespace App\Controllers\Piket;

use App\Controllers\BaseController;
use App\Models\SetWaktuModel;
use App\Models\AbsensiModel;

class Absensi extends BaseController
{

    public function __construct()
    {
        $this->modelWaktu = new SetWaktuModel();
        $this->modelAbsensi = new AbsensiModel();
    }
    public function index()
    {
        $tgl_sekarang = date('Y-m-d');
        $absen = $this->modelAbsensi->where('tgl_absen', $tgl_sekarang)
            ->orderBy('id_absen', 'desc')
            ->find();


        $data = [
            "menu" => "piket",
            "waktu" => $this->modelWaktu->findAll(),
            "absen" => $absen,
        ];
        return view('piket/absensi', $data);
    }

    public function saveSetWaktu($id)
    {
        $this->modelWaktu->update($id, [
            'id_set' => $this->request->getPost('id_set'),
            'jam_masuk' => $this->request->getPost('jam_masuk'),
            'jam_pulang' => $this->request->getPost('jam_pulang'),
            'status_hari' => $this->request->getPost('status_hari'),
        ]);

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }

    public function getDataWaktu($id)
    {
        $data = $this->modelWaktu->find($id);
        return $this->response->setJSON($data);
    }


    public function loadAbsensi()
    {
        $tgl_sekarang = date('Y-m-d');
        $absen = $this->modelAbsensi->where('tgl_absen', $tgl_sekarang)
            ->limit(20)
            ->orderBy('id_absen', 'desc')
            ->find();

        echo "<table class='table  datanew' id='dataTable'>
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Lengkap</th>
                                        <th>Waktu Masuk</th>
                                        <th>Waktu Pulang</th>
                                        <th>Keterangan</th>
                                        <th>Device Id</th>
                                    </tr>
                                </thead>
                                <tbody>";
        $no = 1;
        foreach ($absen as $row) {
            echo "
            <tr>
            <td>" . $no++ . "</td>
            <td>" . $row['nama_lengkap'] . "</td>
            <td>" . $row['jam_masuk'] . "</td>
            <td>" . $row['jam_pulang'] . "</td>
            <td>" . $row['ket'] . "</td>
            <td>" . $row['device_id'] . "</td>
            </tr>
            ";
        }

        echo "</tbody>
                                <tbody>

                                </tbody>
                            </table>";
    }
}
