<?php

namespace App\Controllers\PesertaDidik;

use App\Controllers\BaseController;
use App\Models\JadwalModel;
use App\Models\KelasModel;
use App\Models\DurasiModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;

class Jadwal extends BaseController
{

    public function __construct()
    {
        $this->session = session();
        $this->modelJadwal = new JadwalModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelDurasi = new DurasiModel();
        $this->masterPd = new PesertaDidikModel();
    }
    public function index()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            // 'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            // 'Saturday' => 'Sabtu'
        ];

        $data = [
            "menu" => "pd",
            // "data" => $this->modelJadwal->getJadwalByHari($namaHari, $id_tahun),
            "jadwal" => $this->modelJadwal->findAll(),
            "rombel" => $this->modelRombel->findAll(),
            "kode_guru" => $this->session->get('kode_guru'),
            "hari" => $hariIndo,
        ];
        return view('PesertaDidik/jadwal', data: $data);
    }

    function loadJadwal()
    {
        // $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            // 'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            // 'Saturday' => 'Sabtu'
        ];

        // $namaHari = $hariIndo[$hariIni];
        echo "<div class='row'>";
        foreach ($hariIndo as $hari) {
            echo "
             <div class='col-lg-4'>
                        <div class='card flex-fill bg-white'>
                            <div class='card-header'>
                                <h4>" . $hari . "</h4>
                            </div>
                            <div class='card-body'>
                                <table class='table'>
                                    <thead>
                                        <tr>
                                            <th>Jml</th>
                                            <th>Kode Guru</th>
                                            <th>Nama Guru</th>
                                            <th>Ruangan</th>
                                        </tr>
                                    </thead>
                                    <tbody>";
            $id_tahun = tahun_pelajaran_aktif();
            $nisn = $this->session->get('nisn');
            $pd = $this->masterPd->where('nisn', $nisn)->first();
            $jadwal = $this->modelJadwal->getJadwalByHariPd($hari, $pd['kode_rombel'], $id_tahun);
            foreach ($jadwal as $row_jadwal) {
                echo "
                <tr>
                <td>" . $row_jadwal['jam_ke'] . "</td>
                <td>" . $row_jadwal['kode_guru'] . "</td>
                <td>" . $row_jadwal['nama_lengkap'] . "</td>
                <td>" . $row_jadwal['ruangan'] . "</td>
                </tr>
                ";
            }

            echo "</tbody>
                                </table>
                            </div>
                        </div>
                </div>
        ";
        }

        echo "</div>";
    }
}
