<?php

namespace App\Controllers\PesertaDidik;

use App\Controllers\BaseController;
use App\Models\AbsensiModel;
use App\Models\JadwalModel;
use App\Models\JurusanModel;
use App\Models\KelasModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;
use App\Models\TahunAjaranModel;

class Home extends BaseController
{

	public function __construct()
	{
		$this->session = session();
		$this->modelRombel = new RombelModel();
		$this->modelKelas = new KelasModel();
		$this->modelTP = new TahunAjaranModel();
		$this->modelJurusan = new JurusanModel();
		$this->modelPD = new PesertaDidikModel();
		$this->modelAbsen = new AbsensiModel();
		$this->modelJadwal = new JadwalModel();
	}
	public function index()
	{
		$nisn = $this->session->get('nisn');
		$pd = $this->modelPD->where('nisn', $nisn)->first();
		$hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
		$hariIndo = [
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		];

		$namaHari = $hariIndo[$hariIni];

		$data = [
			"menu" => "pd",
			"nama_lengkap" => $this->session->get('nama_lengkap'),
			"jurusan" => $this->modelJurusan->where('kode_jurusan', $pd['kode_jurusan'])->first(),
			"kelas" => $this->modelKelas->where('kode_kelas', $pd['kode_kelas'])->first(),
			"rombel" => $this->modelRombel->where('kode_rombel', $pd['kode_rombel'])->first(),
			"tp" => $this->modelTP->where('id_tahun', $pd['id_tahun'])->first(),
			'absen' => $this->modelAbsen->where('key', $pd['key'])->orderBy('tgl_absen', 'desc')->findAll(),
			'jadwal' => $this->modelJadwal->getRekapJadwalbyHariPd($namaHari, $pd['kode_rombel']),

		];
		return view('PesertaDidik/home', $data);
	}
}
