<?php

namespace App\Controllers\PesertaDidik;

use App\Controllers\BaseController;
use App\Models\AbsensiModel;
use App\Models\JadwalModel;
use App\Models\JurusanModel;
use App\Models\KelasModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;
use App\Models\TahunAjaranModel;

class Absensi extends BaseController
{

    public function __construct()
    {
        $this->session = session();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelTP = new TahunAjaranModel();
        $this->modelJurusan = new JurusanModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelAbsen = new AbsensiModel();
        $this->modelJadwal = new JadwalModel();
    }
    public function index()
    {
        $nisn = $this->session->get('nisn');
        $pd = $this->modelPD->where('nisn', $nisn)->first();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        $namaHari = $hariIndo[$hariIni];

        $data = [
            "menu" => "pd",
            "nama_lengkap" => $this->session->get('nama_lengkap'),
            "jurusan" => $this->modelJurusan->where('kode_jurusan', $pd['kode_jurusan'])->first(),
            "kelas" => $this->modelKelas->where('kode_kelas', $pd['kode_kelas'])->first(),
            "rombel" => $this->modelRombel->where('kode_rombel', $pd['kode_rombel'])->first(),
            "tp" => $this->modelTP->where('id_tahun', $pd['id_tahun'])->first(),
            'absen' => $this->modelAbsen->where('key', $pd['key'])->orderBy('tgl_absen', 'desc')->findAll(),
            'jadwal' => $this->modelJadwal->getRekapJadwalbyHariPd($namaHari, $pd['kode_rombel']),

        ];
        return view('PesertaDidik/home', $data);
    }

    function rekapAbsenKartu()
    {
        $data = [
            "menu" => "pd",
            "bulan" => date('F'),
        ];

        return view('PesertaDidik/rekapAbsenKartu', $data);
    }


    function loadRekapKartu()
    {

        $bulan = date('m');
        $tahun = date('Y');
        $jumlahHari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
        echo " <div class='row'>";
        for ($i = 1; $i <= $jumlahHari; $i++) {
            // $tanggal = date("", strtotime("", strtotime($i .    "")));
            echo "
            <div class='col-lg-3 col-sm-6 col-12 d-flex'>
            <div class='dash-count'>
            <div class='dash-counts'>
            <h4>Tanggal</h4>
            <h5>Tanggal . " . $i . " </h5>
            </div>
            <div class='dash-imgs'>
            <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round' class='feather feather-user'><path d='M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2'></path><circle cx='12' cy='7' r='4'></circle></svg>
            </div>
            </div>
            </div>";
        }
        echo "</div>";
    }
}
