<?php

namespace App\Controllers\Panel;
use App\Controllers\BaseController;
use App\Models\UserModel;
use App\Models\RombelModel;
use CodeIgniter\API\ResponseTrait;
class User extends BaseController
{
    public function __construct()
    {
        $this->modelUser = new UserModel();
        $this->modelRombel = new RombelModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelUser->getUsersWithRombel(),
            "rombel" => $this->modelRombel->getRombelData(),
        ];
        return view('Panel/user', data: $data);
    }

    public function save_user()
    {
        $aksi = $this->modelUser->save([
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'username' => $this->request->getPost('username'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'akses' => $this->request->getPost('akses'),
            'id_rombel' => $this->request->getPost(index: 'rombel'),
            'status' => $this->request->getPost('status'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        }else{
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

    }

    public function update_user($id)
    {
        // $input = $this->request->getJSON();
        $password = $this->request->getPost('password');
        if (!$password) {
            $aksi = $this->modelUser->update($id, [
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'username' => $this->request->getPost('username'),
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'akses' => $this->request->getPost('akses'),
                'id_rombel' => $this->request->getPost(index: 'rombel'),
                'status' => $this->request->getPost('status'),
            ]);
        }else{
            $aksi = $this->modelUser->update($id, [
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'username' => $this->request->getPost('username'),
                'akses' => $this->request->getPost('akses'),
                'id_rombel' => $this->request->getPost(index: 'rombel'),
                'status' => $this->request->getPost('status'),
            ]);
        }
        

        // if (!$this->modelUser->update($id, row: $input)) {
        //     return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        // }

        if (!$aksi) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
           
        }else{
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        }

       
    }


    public function getData_user($id)
    {
        $data = $this->modelUser->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_user($id)
    {
        if ($this->modelUser->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function import_user()
    {
        $input =  $this->request->getJSON();

    if (!isset($input->data) || empty($input->data)) {
        return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to import data']);
    }

    $data = $input->data;

    foreach ($data as $row) {
        // Pastikan data valid sebelum disimpan
        if (!empty($row->nama_lengkap) && !empty($row->username)) {
            $this->modelUser->save([
                'nama_lengkap' => $row->nama_lengkap,
                'akses' => $row->akses,
                'id_rombel' => $row->rombel,
                'username' => $row->username,
                'password' => password_hash($row->password, PASSWORD_DEFAULT),
                'status' => $row->status
            ]);
        }

    }
    
    return $this->response->setJSON(['status' => 'success', 'message' => 'Data Import successfully']);
    }
}