<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\JurusanModel;
use App\Models\KelasModel;
use App\Models\UserModel;
use App\Models\RombelModel;
use App\Models\PesertaDidikModel;
use CodeIgniter\API\ResponseTrait;

class PesertaDidik extends BaseController
{
    public function __construct()
    {
        $this->modelUser = new UserModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelJurusan = new JurusanModel();
        $this->modelPD = new PesertaDidikModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelPD->getDataView(),
            "rombel" => $this->modelRombel->getRombelData(),
            "jurusan" => $this->modelJurusan->findAll(),
            "kelas" => $this->modelKelas->findAll(),
        ];
        return view(name: 'Panel/pesertaDidik', data: $data);
    }

    public function save()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $aksi = $this->modelPD->save([
            'nisn' => $this->request->getPost('nisn'),
            'nik' => $this->request->getPost('nik'),
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'tmp_lahir' => $this->request->getPost('tmp_lahir'),
            'tgl_lahir' => $this->request->getPost('tgl_lahir'),
            'jk' => $this->request->getPost('jk'),
            'alamat' => $this->request->getPost('alamat'),
            'email' => $this->request->getPost('email'),
            'no_hp' => $this->request->getPost('no_hp'),
            'nama_ayah' => $this->request->getPost('nama_ayah'),
            'no_hp_ayah' => $this->request->getPost('no_hp_ayah'),
            'nama_ibu' => $this->request->getPost('nama_ibu'),
            'no_hp_ibu' => $this->request->getPost('no_hp_ibu'),
            'nama_wali' => $this->request->getPost('nama_wali'),
            'no_hp_wali' => $this->request->getPost('no_hp_wali'),
            'status' => $this->request->getPost('status'),
            'kode_jurusan' => $this->request->getPost('kode_jurusan'),
            'kode_kelas' => $this->request->getPost('kode_kelas'),
            'kode_rombel' => $this->request->getPost('kode_rombel'),
            'key' => $this->request->getPost('key'),
            'id_tahun' => $id_tahun,
            'password' => password_hash($row->password, PASSWORD_DEFAULT),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    public function update($id)
    {
        // $input = $this->request->getJSON();
        $password = $this->request->getPost('password');
        $id_tahun = tahun_pelajaran_aktif();

        if (!$password) {
            $aksi = $this->modelPD->update($id, [
                'nisn' => $this->request->getPost('nisn'),
                'nik' => $this->request->getPost('nik'),
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'tmp_lahir' => $this->request->getPost('tmp_lahir'),
                'tgl_lahir' => $this->request->getPost('tgl_lahir'),
                'jk' => $this->request->getPost('jk'),
                'alamat' => $this->request->getPost('alamat'),
                'email' => $this->request->getPost('email'),
                'no_hp' => $this->request->getPost('no_hp'),
                'nama_ayah' => $this->request->getPost('nama_ayah'),
                'no_hp_ayah' => $this->request->getPost('no_hp_ayah'),
                'nama_ibu' => $this->request->getPost('nama_ibu'),
                'no_hp_ibu' => $this->request->getPost('no_hp_ibu'),
                'nama_wali' => $this->request->getPost('nama_wali'),
                'no_hp_wali' => $this->request->getPost('no_hp_wali'),
                'status_pd' => $this->request->getPost('status'),
                'kode_jurusan' => $this->request->getPost('kode_jurusan'),
                'kode_kelas' => $this->request->getPost('kode_kelas'),
                'kode_rombel' => $this->request->getPost('kode_rombel'),
                'password' => password_hash($password, PASSWORD_DEFAULT),
            ]);
        } else {
            $aksi = $this->modelPD->update($id, [
                'nisn' => $this->request->getPost('nisn'),
                'nik' => $this->request->getPost('nik'),
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'tmp_lahir' => $this->request->getPost('tmp_lahir'),
                'tgl_lahir' => $this->request->getPost('tgl_lahir'),
                'jk' => $this->request->getPost('jk'),
                'alamat' => $this->request->getPost('alamat'),
                'email' => $this->request->getPost('email'),
                'no_hp' => $this->request->getPost('no_hp'),
                'nama_ayah' => $this->request->getPost('nama_ayah'),
                'no_hp_ayah' => $this->request->getPost('no_hp_ayah'),
                'nama_ibu' => $this->request->getPost('nama_ibu'),
                'no_hp_ibu' => $this->request->getPost('no_hp_ibu'),
                'nama_wali' => $this->request->getPost('nama_wali'),
                'no_hp_wali' => $this->request->getPost('no_hp_wali'),
                'status_pd' => $this->request->getPost('status'),
                'kode_jurusan' => $this->request->getPost('kode_jurusan'),
                'kode_kelas' => $this->request->getPost('kode_kelas'),
                'kode_rombel' => $this->request->getPost('kode_rombel'),
            ]);
        }


        // if (!$this->modelUser->update($id, row: $input)) {
        //     return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        // }

        if (!$aksi) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        } else {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        }
    }


    public function getDataView($id)
    {
        $data = $this->modelPD->getDataViewDetail($id);
        $table = "
            <div class='row'>
                    <div class='col-8'>
                    <table class='table' width='100%'>
                         <tr>
                    <th colspan='6'><b>A. Identitas / Data Diri</b></th>
                </tr>
                <tr>
                    <td width='10%'>NISN</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['nisn'] . "</td>
                    <td width='10%'>Nama Lengkap</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['nama_lengkap'] . "</td>
                </tr>
                <tr>
                    <td width='10%'>Tempat Lahir</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['tmp_lahir'] . "</td>
                    <td width='10%'>Tanggal Lahir</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['tgl_lahir'] . "</td>
                </tr>
                <tr>
                    <td width='10%'>Jenis Kelamin</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['jk'] . "</td>
                    <td width='10%'>Alamat</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['alamat'] . "</td>
                </tr>
                <tr>
                    <td width='10%'>Email</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['email'] . "</td>
                    <td width='10%'>No HP</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['no_hp'] . "</td>
                </tr>
                <tr>
                    <th width='10%' colspan='6'><b>B. Orang Tua / Wali</b></th>
                </tr>
                <tr>
                    <td width='10%'>Nama Ayah</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['nama_ayah'] . "</td>
                    <td width='10%'>No HP</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['no_hp_ayah'] . "</td>
                </tr>
                <tr>
                    <td width='10%'>Nama Ibu</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['nama_ibu'] . "</td>
                    <td width='10%'>No Hp</td>
                    <td width='2%'>:</td>
                    <td width='40%'>" . $data[0]['no_hp_ibu'] . "</td>
                </tr>
                <tr>
                    <td width='10%'>Nama Wali</td>
                    <td width='2%'>:</td>
                    <td></td>
                    <td width='100'>No Hp</td>
                    <td width='10%'>:</td>
                    <td></td>
                </tr>
               </table>
                    </div>
                    <div class='col-4'>
                    <table class='table' width='100%'>
                    <tr>
                            <td colspan='3'><b>C. Informasi Akademik</b></td>
                        </tr>
                        <tr>
                            <td width='100'>Jurusan</td>
                            <td width='20'>:</td>
                            <td width='100'>" . $data[0]['nama_jurusan'] . "</td>
                        </tr>
                        <tr>
                            <td width='100'>Kelas</td>
                            <td width='20'>:</td>
                            <td width='100'>" . $data[0]['nama_kelas'] . "</td>
                        </tr>
                        <tr>
                            <td width='100'>Rombel</td>
                            <td width='20'>:</td>
                            <td width='100'>" . $data[0]['nama_rombel'] . "</td>
                        </tr>
                        <tr>
                            <td width='100'>Tahun Pelajaran Aktif</td>
                            <td width='20'>:</td>
                            <td width='100'>" . $data[0]['tahun_pelajaran'] . "</td>
                        </tr>
                        <tr>
                            <td width='100'>Semester</td>
                            <td width='20'>:</td>
                            <td width='100'>" . $data[0]['semester_aktif'] . "</td>
                        </tr>
                    </table>
                    </div>
                </div>
              
        ";
        return $table;
    }


    public function getData($id)
    {

        $data = $this->modelPD->getDataViewDetail($id);
        return $this->response->setJSON($data[0])->setHeader('Content-Type', 'application/json');
    }

    public function delete($id)
    {
        if ($this->modelPD->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function import()
    {
        $input =  $this->request->getJSON();
        $id_tahun = tahun_pelajaran_aktif();

        if (!isset($input->data) || empty($input->data)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to import data']);
        }

        $data = $input->data;

        foreach ($data as $row) {
            // Pastikan data valid sebelum disimpan
            if (!empty($row->nama_lengkap) && !empty($row->nisn)) {
                $this->modelPD->save([
                    'nisn' => $row->nisn,
                    'nik' => $row->nik,
                    'nama_lengkap' => $row->nama_lengkap,
                    'tmp_lahir' => $row->tmp_lahir,
                    'tgl_lahir' => $row->tgl_lahir,
                    'jk' => $row->jk,
                    'alamat' => $row->alamat,
                    'email' => $row->email,
                    'no_hp' => $row->no_hp,
                    'nama_ayah' => $row->nama_ayah,
                    'no_hp_ayah' => $row->no_hp_ayah,
                    'nama_ibu' => $row->nama_ibu,
                    'no_hp_ibu' => $row->no_hp_ibu,
                    'nama_wali' => $row->nama_wali,
                    'no_hp_wali' => $row->no_hp_wali,
                    'status_pd' => $row->status,
                    'kode_jurusan' => $row->kode_jurusan,
                    'kode_kelas' => $row->kode_kelas,
                    'kode_rombel' => $row->kode_rombel,
                    'key' => $row->key,
                    'id_tahun' => $id_tahun,
                    'password' => password_hash($row->password, PASSWORD_DEFAULT),
                ]);
            }
        }

        // return $this->response->setJSON(['status' => 'success', 'message' => 'Data Import successfully']);
    }
}
