<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\DurasiModel;
use App\Models\UserModel;
use App\Models\RombelModel;
use App\Models\KelasModel;
use App\Models\JadwalModel;
use CodeIgniter\API\ResponseTrait;
use Dompdf\Dompdf;
use Dompdf\Options;
use CodeIgniter\RESTful\ResourceController;

class Jadwal extends BaseController
{
    public function __construct()
    {
        $this->modelUser = new UserModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelJadwal = new JadwalModel();
        $this->modelDurasi = new DurasiModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelUser->getUsersWithRombel(),
            "rombel" => $this->modelRombel->getRombelData(),
            "kelas" => $this->modelKelas->findAll(),
            "jml_kelas" => $this->modelKelas->countAll(),
            "durasi" => $this->modelDurasi->findAll(),
        ];
        return view('Panel/jadwal', data: $data);
    }

    public function save()
    {
        $aksi = $this->modelUser->save([
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'username' => $this->request->getPost('username'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'akses' => $this->request->getPost('akses'),
            'id_rombel' => $this->request->getPost(index: 'rombel'),
            'status' => $this->request->getPost('status'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    public function LoadJadwal()
    {
        $kelas =  $this->modelKelas->findAll();
        $jml_kelas = $this->modelKelas->countAll();
        $jml_rombel = $this->modelRombel->getRombelData();

        echo "
         <table class='table' style='width:3500px'>
                                <thead>
                                    <tr>
                                        <th rowspan='4' style='vertical-align:middle;'>HARI</th>
                                        <th rowspan='4' style='vertical-align:middle;'>JAM</th>
                                        <th rowspan='4' style='vertical-align:middle;'>WAKTU</th>
                                        <th colspan='" . count($jml_rombel) . "' style='text-align:center'>KELAS</th>
                                    </tr><tr>";
        // $Rkel = array();
        foreach ($kelas as $kel) {
            $jml_rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            echo "
                                    <td colspan='" . count($jml_rombel) . "' align='center'>" . $kel['nama_kelas'] . "</td>
                                    ";
            // array_push($Rkel,$kel['kode_kelas']);
        }
        //    $rombel = $this->modelJadwal->getRombelKodeKelas($kel['kode_kelas']);
        echo "</tr>
                                <tr>";
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            foreach ($rombel as $rom) {
                echo "
                                        <td>" . $rom['nama_rombel'] . "</td>
                                        ";
            }
        }
        echo "</tr>
                                 <tr>";
        $no = 1;
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);

            foreach ($rombel as $rom) {
                echo "
                                        <td align='center'>" . $no++ . "</td>
                                        ";
            }
        }
        echo "</tr>
                                </thead>
                                <tbody>";
        $hari = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat'];
        $jadwal = $this->modelJadwal->findAll();
        $jml_colom = count($jml_rombel) + 4;
        $durasiJumat = $this->modelDurasi->bystatusHariJumat();
        $durasiKBM = $this->modelDurasi->bystatusHariKBM();
        if (empty($jadwal)) {
            echo "<tr>
                                    <td colspan='" . $jml_colom . "'>Data Tidak ada / Belum Digenerate</td>
                                    </tr>";
        } else {
            foreach ($hari as $h) {
                if ($h == 'Jumat') {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiJumat) . "'>" . $h . "</td>
                                           ";
                    foreach ($durasiJumat as $durJum) {
                        echo "
                                            <td align='center'>" . $durJum['jam_ke'] . "</td>
                                            <td align='center'>" . $durJum['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durJum['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();


                                echo "
                                                   <td><input value='" . $jadwal['kode_guru'] . "' type='text' class='form-control' name='kode_guru[]' id='kode_guru' data-hari='" . $h . "' data-rombel='" . $rom['kode_rombel'] . "' data-jam='" . $durKBM['jam_ke'] . "' onkeyup='saveJadwal()'></td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                } else {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiKBM) . "'>" . $h . "</td> ";
                    foreach ($durasiKBM as $durKBM) {
                        echo "
                                            <td align='center'>" . $durKBM['jam_ke'] . "</td>
                                            <td align='center'>" . $durKBM['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durKBM['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();
                                echo "
                                                    <td><input value='" . $jadwal['kode_guru'] . "' type='text' class='form-control' name='kode_guru[]' id='kode_guru' data-hari='" . $h . "' data-rombel='" . $rom['kode_rombel'] . "' data-jam='" . $durKBM['jam_ke'] . "' onkeyup='saveJadwal()'></td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                }
            }
        }

        echo "
                                   <tr>
                                   <td align='center'>Ruangan</td>
                                   </tr>
                                  ";

        echo "</tbody>
                            </table>
        ";
    }

    function updateJadwal()
    {

        $hari = trim($this->request->getVar('hari'));
        $jam_ke = intval($this->request->getVar('jam_ke'));
        $kode_rombel = trim($this->request->getVar('kode_rombel'));
        $kode_guru = $this->request->getVar('kode_guru');


        $existing = $this->modelJadwal->where('hari', $hari)
            ->where('jam_ke', $jam_ke)
            ->where('kode_rombel', $kode_rombel) // Sesuaikan dengan database
            ->first();


        // Update data jika ditemukan
        $aksi = $this->modelJadwal->where('hari', $hari)
            ->where('jam_ke', $jam_ke)
            ->where('kode_rombel', $kode_rombel)
            ->set(['kode_guru' => $kode_guru])
            ->update();

        if (!$aksi) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Jadwal Gagal diperbarui']);
        } else {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Jadwal berhasil diperbarui']);
        }
    }

    function generateJadwalPost()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $kelas =  $this->modelKelas->findAll();
        $rombel = $this->modelRombel->getRombelData();
        $hari = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat'];
        // $kelas = ['X TKJ', 'XI TKJ', 'XII TKJ', 'X TBSM', 'XI TBSM', 'XII TBSM', 'X MM', 'XI MM', 'XII MM'];
        // $rombel = ['A', 'B', 'C'];
        $durasi = $this->modelDurasi->findAll();
        $durasiJumat = $this->modelDurasi->bystatusHariJumat();
        $durasiKBM = $this->modelDurasi->bystatusHariKBM();

        $kode_kelas = array();
        foreach ($kelas as $row_kelas) {
            array_push($kode_kelas, $row_kelas['kode_kelas']);
        }

        $id_rombel = array();
        $ruangan = array();
        foreach ($rombel as $rom) {
            array_push($id_rombel, $rom['id_rombel']);
            array_push($ruangan, $rom['ruangan']);
        }

        $dw_jumat = array();
        $jamke_jumat = array();
        foreach ($durasiJumat as $durJumat) {
            array_push($dw_jumat, $durJumat['durasi']);
            array_push($jamke_jumat, $durJumat['jam_ke']);
        }

        $dw_KBM = array();
        $jamke_KBM = array();
        foreach ($durasiKBM as $durKBM) {
            array_push($dw_KBM, $durKBM['durasi']);
            array_push($jamke_KBM, $durKBM['jam_ke']);
        }

        $dataJadwal = [];

        foreach ($hari as $h) {
            if ($h == 'Jumat') {
                for ($jam = 1; $jam <= 6; $jam++) {
                    foreach ($rombel as $rw_rom) {
                        $dataJadwal[] = [
                            'hari'   => $h,
                            'jam_ke' => $jam,
                            // 'durasi' => $dw_jumat[array_rand($dw_jumat)],
                            'id_tahun' => $id_tahun,
                            'kelas'  => $kode_kelas[array_rand($kode_kelas)],
                            'kode_rombel' => $rw_rom['kode_rombel'],
                            'ruangan' => $rw_rom['ruangan'],
                        ];
                    }
                }
            } else {
                for ($jam = 1; $jam <= 11; $jam++) {
                    foreach ($rombel as $rw_rom) {
                        $dataJadwal[] = [
                            'hari'   => $h,
                            'jam_ke' => $jam,
                            // 'durasi' => $dw_KBM[array_rand($dw_KBM)],
                            'id_tahun' => $id_tahun,
                            'kelas'  => $kode_kelas[array_rand($kode_kelas)],
                            'kode_rombel' => $rw_rom['kode_rombel'],
                            'ruangan' => $rw_rom['ruangan'],
                        ];
                    }
                }
            }
        }

        // echo "<pre>";
        // print_r($dataJadwal);
        // echo "</pre>";

        $this->modelJadwal->insertBatch($dataJadwal);
        return $this->response->setJSON(['status' => 'success', 'message' => 'Jadwal berhasil digenerate']);
    }

    public function saveWaktu()
    {
        $aksi = $this->modelDurasi->save([
            'jam_ke' => $this->request->getPost('jam_ke'),
            'durasi' => $this->request->getPost('durasi'),
            'status_hari' => $this->request->getPost('status_hari'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    function waktuBelajar()
    {
        $durasi =  $this->modelDurasi->findAll();
        foreach ($durasi as $row_durasi) {
            echo "
            <tr>
                <td>" . $row_durasi['jam_ke'] . "</td>
                <td>" . $row_durasi['durasi'] . "</td>
                <td>" . $row_durasi['status_hari'] . "</td>
                <td><button type='button' onclick='deleteWaktu(" . $row_durasi['id_waktu'] . ")' class='btn btn-default'><img src='assets/img/icons/delete.svg' alt='img'></button></td>
            </tr>
            ";
        }
    }

    function deleteWaktu($id)
    {
        if ($this->modelDurasi->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }


    function jadwalPreview()
    {
        $data = [
            "menu" => "panel",
        ];
        return view('Panel/previewJadwal', $data);
    }

    public function LoadJadwalPDf()
    {
        $kelas =  $this->modelKelas->findAll();
        $jml_kelas = $this->modelKelas->countAll();
        $jml_rombel = $this->modelRombel->getRombelData();

        echo "
         <table class='table' style='width:100%; font-size:10px' >
                                <thead>
                                    <tr>
                                        <th rowspan='4' style='vertical-align:middle;'>HARI</th>
                                        <th rowspan='4' style='vertical-align:middle;'>JAM</th>
                                        <th rowspan='4' style='vertical-align:middle;'>WAKTU</th>
                                        <th colspan='" . count($jml_rombel) . "' style='text-align:center'>KELAS</th>
                                    </tr><tr>";
        // $Rkel = array();
        foreach ($kelas as $kel) {
            $jml_rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            echo "
                                    <td colspan='" . count($jml_rombel) . "' align='center'>" . $kel['nama_kelas'] . "</td>
                                    ";
            // array_push($Rkel,$kel['kode_kelas']);
        }
        //    $rombel = $this->modelJadwal->getRombelKodeKelas($kel['kode_kelas']);
        echo "</tr>
                                <tr>";
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
            foreach ($rombel as $rom) {
                echo "
                                        <td>" . $rom['nama_rombel'] . "</td>
                                        ";
            }
        }
        echo "</tr>
                                 <tr>";
        $no = 1;
        foreach ($kelas as $kel) {
            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);

            foreach ($rombel as $rom) {
                echo "
                                        <td align='center'>" . $no++ . "</td>
                                        ";
            }
        }
        echo "</tr>
                                </thead>
                                <tbody>";
        $hari = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat'];
        $jadwal = $this->modelJadwal->findAll();
        $jml_colom = count($jml_rombel) + 4;
        $durasiJumat = $this->modelDurasi->bystatusHariJumat();
        $durasiKBM = $this->modelDurasi->bystatusHariKBM();
        if (empty($jadwal)) {
            echo "<tr>
                                    <td colspan='" . $jml_colom . "'>Data Tidak ada / Belum Digenerate</td>
                                    </tr>";
        } else {
            foreach ($hari as $h) {
                if ($h == 'Jumat') {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiJumat) . "'>" . $h . "</td>
                                           ";
                    foreach ($durasiJumat as $durJum) {
                        echo "
                                            <td align='center'>" . $durJum['jam_ke'] . "</td>
                                            <td align='center'>" . $durJum['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durJum['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();


                                echo "
                                                    <td>" . $jadwal['kode_guru'] . "</td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                } else {
                    echo "
                                            <tr>
                                            <td align='center' rowspan='" . count($durasiKBM) . "'>" . $h . "</td> ";
                    foreach ($durasiKBM as $durKBM) {
                        echo "
                                            <td align='center'>" . $durKBM['jam_ke'] . "</td>
                                            <td align='center'>" . $durKBM['durasi'] . "</td>";
                        foreach ($kelas as $kel) {
                            $rombel = $this->modelRombel->getRombelKodeKelas($kel['kode_kelas']);
                            foreach ($rombel as $rom) {
                                $jadwal = $this->modelJadwal->where('hari', $h)
                                    ->where('jam_ke', $durKBM['jam_ke'])
                                    ->where('kode_rombel', $rom['kode_rombel']) // Sesuaikan dengan database
                                    ->first();
                                echo "
                                                    <td>" . $jadwal['kode_guru'] . "</td>
                                                    ";
                            }
                        }
                        echo "</tr>
                                           ";
                    }
                }
            }
        }

        echo "
                                   <tr>
                                   <td align='center'>Ruangan</td>
                                   </tr>
                                  ";

        echo "</tbody>
                            </table>
        ";
    }
}
