<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\GtkModel;
use App\Models\JurusanModel;
use App\Models\TahunAjaranModel;
use App\Models\MapelModel;
use App\Models\PesertaDidikModel;
use App\Models\RombelModel;
use CodeIgniter\API\ResponseTrait;

class Home extends BaseController
{
    protected $tahunAjaran;
    protected $mapel;
    use ResponseTrait;

    public function __construct()
    {
        $this->session = session();
        $this->modelTahun = new TahunAjaranModel();
        $this->modelMapel = new MapelModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelRombel = new RombelModel();
        $this->modelJurusan = new JurusanModel();
        $this->modelGTK = new GtkModel();
    }
    public function index()
    {

        

        $data = [
            "menu" => "panel",
            "jml_gtk" => $this->modelGTK->countAll(),
            "jml_rombel" => $this->modelRombel->getRombelData(),
            "jml_jurusan" => $this->modelJurusan->countAll(),
            "jml_PesertaDidik" => $this->modelPD->countAll(),
            "nama_lengkap" => $this->session->get('nama_lengkap'),
        ];
        return view('Panel/home', $data);
    }
}
