<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\GtkModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\RESTful\ResourceController;

class Gtk extends BaseController
{
    public function __construct()
    {
        $this->modelGTK = new GtkModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelGTK->findAll(),
        ];
        return view('Panel/gtk', data: $data);
    }

    public function save_gtk()
    {
        $aksi = $this->modelGTK->save([
            'nip' => $this->request->getPost('nip'),
            'nuptk' => $this->request->getPost('nuptk'),
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
            'tm_lahir' => $this->request->getPost('tm_lahir'),
            'tgl_lahir' => $this->request->getPost('tgl_lahir'),
            'no_hp' => $this->request->getPost('no_hp'),
            'kode_guru' => $this->request->getPost('kode_guru'),
            'status' => $this->request->getPost('status'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    public function update_gtk($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelGTK->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }


    public function getData_gtk($id)
    {
        $data = $this->modelGTK->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_gtk($id)
    {
        if ($this->modelGTK->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function import_gtk()
    {
        $input =  $this->request->getJSON();

        if (!isset($input->data) || empty($input->data)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to import data']);
        }

        $data = $input->data;

        foreach ($data as $row) {
            // Pastikan data valid sebelum disimpan
            if (!empty($row->nama_lengkap) && !empty($row->jenis_kelamin)) {
                $this->modelGTK->save([
                    'nip' => $row->nip,
                    'nuptk' => $row->nuptk,
                    'nama_lengkap' => $row->nama_lengkap,
                    'tm_lahir' => $row->tm_lahir,
                    'tgl_lahir' => $row->tgl_lahir,
                    'ijazah_terakhir' => $row->ijazah_terakhir,
                    'no_hp' => $row->no_hp,
                    'status' => $row->status,
                    'jenis_kelamin' => $row->jenis_kelamin,
                    'key' => $row->key,
                    'kode_guru' => $row->kode_guru,
                    'password' => $row->password
                ]);
            }
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data Import successfully']);
    }


    public function processImport()
    {


        $input = $this->request->getJSON();

        if (!isset($input->data) || empty($input->data)) {
            return $this->failValidationError('Tidak ada data yang diimpor.');
        }

        $data = $input->data;

        foreach ($data as $row) {
            // Pastikan data valid sebelum disimpan
            if (!empty($row->kd_mapel) && !empty($row->nama_mapel)) {
                $this->modelMapel->save([
                    'nip' => $row->nip,
                    'id_gtk' => $row->id_gtk,
                    'nuptk' => $row->nuptk,
                    'nama_lengkap' => $row->nama_lengkap,
                    'tm_lahir' => $row->tm_lahir,
                    'tgl_lahir' => $row->tgl_lahir,
                    'ijazah_terakhir' => $row->ijazah_terakhir,
                    'no_hp' => $row->no_hp,
                    'status' => $row->status,
                    'jenis_kelamin' => $row->jenis_kelamin,
                    'key' => $row->key,
                    'kode_guru' => $row->kode_guru,
                    'password' => $row->password
                ]);
            }
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data Import successfully']);
    }
}
