<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\DeviceModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\RESTful\ResourceController;

class Device extends BaseController
{
    public function __construct()
    {
        $this->modelDevice = new DeviceModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelDevice->findAll(),
        ];
        return view('Panel/device', data: $data);
    }

    public function listDevice()
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelDevice->findAll(),
        ];
        return view('Panel/device', data: $data);
    }

    public function getAll()
    {
        $data = $this->modelDevice->findAll();
        return $this->response->setJSON(['data' => $data]);
    }

    public function save()
    {
        $aksi = $this->modelDevice->save([
            'device_id' => $this->request->getPost('device_id'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved']);
        }
    }

    public function getData($id)
    {
        $data = $this->modelDevice->find($id);
        return $this->response->setJSON($data);
    }

    public function delete($id)
    {
        if ($this->modelDevice->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function update($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelDevice->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }



    public function reboot()
    {
        $device_id = $this->request->getPost('device_id');

        if (!$device_id) {
            return $this->fail('Device ID tidak valid', 400);
        }

        $espDevice = $this->modelDevice->where('device_id', $device_id)->first();

        if (!$espDevice) {
            return $this->fail('ESP32 tidak ditemukan', 404);
        }

        $esp_ip = $espDevice['ip_address'];
        $url = "http://$esp_ip/reboot";

        // $espIp = "http://192.168.1.100/reboot"; // Ganti dengan IP ESP32

        $client = \Config\Services::curlrequest();
        $response = $client->get($url);

        return $this->response->setJSON([
            'message' => 'Perintah reboot dikirim',
            'status' => $response->getBody()
        ]);
    }
}
