<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\DeviceModel;
use App\Models\JurusanModel;
use App\Models\PesertaDidikModel;
use App\Models\RegModel;
use App\Models\RombelModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\RESTful\ResourceController;

class Card extends BaseController
{
    public function __construct()
    {
        $this->modelDevice = new DeviceModel();
        $this->modelReg = new RegModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelRombel = new RombelModel();
        $this->modelJurusan = new JurusanModel();
    }
    public function index(): string
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelReg->findAll(),
            "pd" => $this->modelPD->getDataCard(),
        ];
        return view('Panel/card', data: $data);
    }

    function loadDataReg()
    {
        $reg = $this->modelReg
            ->orderBy('id_reg', 'desc')
            ->findAll();
        if ($reg) {
            $no = 1;
            foreach ($reg as $row) {
                echo
                "<tr>
                    <td>" . $no++ . "</td>
                    <td>" . $row['device_id'] . "</td>
                    <td><input class='form-control' value='" . $row['key'] . "'></td>
                    <td>" . $row['time'] . "</td>
                </tr>";
            }
        } else {
            echo
            "<tr>
                <td colspan='5'>Data Kosong</td>
            </tr>";
        }
    }

    function updateKey()
    {
        $nisn = $this->request->getVar('nisn');
        $key = $this->request->getVar('key');

        $cek_reg = $this->modelReg->where('key', $key)->first();
        if ($cek_reg) {
            $this->modelReg->delete($cek_reg['id_reg']);
        }

        $aksi = $this->modelPD->where('nisn', $nisn)->set(['key' => $key])->update();

        if (!$aksi) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Jadwal Gagal diperbarui']);
        } else {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Jadwal berhasil diperbarui']);
        }
    }
}
