<?php

namespace App\Controllers\Panel;

use App\Controllers\BaseController;
use App\Models\GtkModel;
use App\Models\TahunAjaranModel;
use App\Models\MapelModel;
use App\Models\KelasModel;
use App\Models\RombelModel;
use App\Models\JurusanModel;
use CodeIgniter\API\ResponseTrait;

class Akademik extends BaseController
{

    protected $tahunAjaran;
    protected $mapel;
    use ResponseTrait;

    public function __construct()
    {
        $this->modelTahun = new TahunAjaranModel();
        $this->modelKelas = new KelasModel();
        $this->modelMapel = new MapelModel();
        $this->modelRombel = new RombelModel();
        $this->modelGtk = new GtkModel();
        $this->modelJurusan = new JurusanModel();
    }

    //MULAI FUNC MAPEL
    public function mapel()
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelMapel->orderBy('kd_mapel', 'DESC')->findAll(),
        ];
        return view('Panel/mapel', $data);
    }


    public function save_mapel()
    {
        $aksi = $this->modelMapel->save([
            'kd_mapel' => $this->request->getPost('kd_mapel'),
            'nama_mapel' => $this->request->getPost('nama_mapel'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    public function update_mapel($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelMapel->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }

    public function getAll_mapel()
    {
        $data = $this->modelMapel->findAll();
        return $this->respond(['data' => $data]);
    }


    public function getData_mapel($id)
    {
        $data = $this->modelMapel->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_mapel($id)
    {
        if ($this->modelMapel->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function import_mapel()
    {
        $input = $this->request->getJSON();

        if (!isset($input->data) || empty($input->data)) {
            return $this->failValidationError('Tidak ada data yang diimpor.');
        }

        $data = $input->data;

        foreach ($data as $row) {
            // Pastikan data valid sebelum disimpan
            if (!empty($row->kd_mapel) && !empty($row->nama_mapel)) {
                $this->modelMapel->save([
                    'kd_mapel' => $row->kd_mapel,
                    'nama_mapel' => $row->nama_mapel,
                ]);
            }
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data Import successfully']);
    }

    //FUNC AKHIR MAPEL


    //FUNC TAHUN PELAJARAN
    public function tahunAjaran()
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelTahun->orderBy('id_tahun', 'DESC')->findAll(),
        ];
        return view('Panel/tahunAjaran', $data);
    }

    public function save_tahunAjaran()
    {
        $this->modelTahun->save([
            'id_tahun' => $this->request->getPost('id_tahun'),
            'tahun_pelajaran' => $this->request->getPost('tahun_pelajaran'),
            'status' => $this->request->getPost('status'),
            'semester_aktif' => $this->request->getPost('semester_aktif'),
        ]);

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }

    public function getData_tahunAjaran($id)
    {
        $data = $this->modelTahun->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_tahunAjaran($id)
    {
        if ($this->modelTahun->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    //FUNC KELAS
    public function kelas()
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelKelas->findAll(),
        ];
        return view('Panel/kelas', $data);
    }

    public function getAll_kelas()
    {
        $data = $this->modelKelas->findAll();
        return $this->respond(['data' => $data]);
    }

    public function save_kelas()
    {
        $aksi = $this->modelKelas->save([
            'kode_kelas' => $this->request->getPost('kode_kelas'),
            'nama_kelas' => $this->request->getPost('nama_kelas'),
            'status' => $this->request->getPost('status'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved']);
        }
    }

    public function getData_kelas($id)
    {
        $data = $this->modelKelas->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_kelas($id)
    {
        if ($this->modelKelas->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function update_kelas($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelKelas->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }

    //FUNC ROMBEL
    public function rombel()
    {

        $data = [
            "menu" => "panel",
            "data" => $this->modelRombel->findAll(),
            "kelas" => $this->modelKelas->findAll(),
            "tahun" => $this->modelTahun->findAll(),
            "jurusan" => $this->modelJurusan->findAll(),
            "rombel" => $this->modelRombel->getRombelData(),
            "gtk" => $this->modelGtk->findAll(),

        ];
        return view('Panel/rombel', $data);
    }

    public function getAll_rombel()
    {

        $data = $this->modelRombel->getRombelData();
        return $this->response->setContentType('application/json')->setJSON(['data' => $data]);

        //  return $this->response->setJSON(['data' => $data]);

    }

    public function save_rombel()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $aksi = $this->modelRombel->save([
            'kode_rombel' => $this->request->getPost('kode_rombel'),
            'nama_rombel' => $this->request->getPost('nama_rombel'),
            'kode_kelas' => $this->request->getPost('kode_kelas'),
            'kode_jurusan' => $this->request->getPost('kode_jurusan'),
            'walikelas' => $this->request->getPost('walikelas'),
            'id_tahun_pelajaran' => $id_tahun,
            'status' => $this->request->getPost('status'),
            'kode_guru' => $this->request->getPost('kode_guru'),
            'ruangan' => $this->request->getPost('ruangan'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved']);
        }
    }

    public function getData_rombel($id)
    {

        $data = $this->modelRombel->find($id);
        return $this->response->setJSON($data)->setHeader('Content-Type', 'application/json');
    }

    public function delete_rombel($id)
    {
        if ($this->modelRombel->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function update_rombel($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelRombel->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }



    //FUNC JURUSAN
    public function jurusan()
    {
        $data = [
            "menu" => "panel",
            "data" => $this->modelJurusan->findAll(),
        ];
        return view('Panel/jurusan', data: $data);
    }

    public function getAll_jurusan()
    {
        $data = $this->modelJurusan->findAll();
        return $this->respond(['data' => $data]);
    }

    public function save_jurusan()
    {
        $aksi = $this->modelJurusan->save([
            'kode_jurusan' => $this->request->getPost('kode_jurusan'),
            'nama_jurusan' => $this->request->getPost('nama_jurusan'),
            'status' => $this->request->getPost('status'),
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved']);
        }
    }

    public function getData_jurusan($id)
    {
        $data = $this->modelJurusan->find($id);
        return $this->response->setJSON($data);
    }

    public function delete_jurusan($id)
    {
        if ($this->modelJurusan->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    public function update_jurusan($id)
    {
        $input = $this->request->getJSON();
        if (!$this->modelJurusan->update($id, $input)) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }

        return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
    }
}
