<?php

namespace App\Controllers;

use App\Models\GtkModel;
use App\Models\PesertaDidikModel;
use App\Models\UserModel;

class Login extends BaseController
{
    public function __construct()
    {
        $this->modelGTK = new GtkModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelUser = new UserModel();
    }
    public function index(): string
    {
        return view('login');
    }

    function SignIn()
    {
        $session = session();

        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $user = $this->modelUser->where('username', $username)
            ->where('status', 'active')
            ->first();

        $gtk = $this->modelGTK->where('username', $username)
            ->where('status', 'active')
            ->first();


        $pesertadidik = $this->modelPD->where('nisn', $username)
            ->where('status_pd', 'aktif')
            ->first();

        if ($user) {

            if ($user && password_verify($password, $user['password'])) {
                if ($user['akses'] == 'walikelas'  && $user['akses'] != null) {
                    $session->set([
                        'user_id' => $user['id_user'],
                        'username' => $user['username'],
                        'nama_lengkap' => $user['nama_lengkap'],
                        'id_rombel' => $user['id_rombel'],
                        'role' => 'walikelas',
                        'logged_in' => true
                    ]);
                    return redirect()->to('walikelas');
                } elseif ($user['akses'] == 'admin') {
                    $session->set([
                        'user_id' => $user['id_user'],
                        'username' => $user['username'],
                        'nama_lengkap' => $user['nama_lengkap'],
                        'role' => 'admin',
                        'logged_in' => true
                    ]);
                    return redirect()->to('panel');
                } elseif ($user['akses'] == 'piket') {
                    $session->set([
                        'user_id' => $user['id_user'],
                        'username' => $user['username'],
                        'nama_lengkap' => $user['nama_lengkap'],
                        'role' => 'piket',
                        'logged_in' => true
                    ]);
                    return redirect()->to('piket');
                } elseif ($user['akses'] == 'bk') {
                    $session->set([
                        'user_id' => $user['id_user'],
                        'username' => $user['username'],
                        'nama_lengkap' => $user['nama_lengkap'],
                        'role' => 'bk',
                        'logged_in' => true
                    ]);
                    return redirect()->to('bk');
                } else {
                    $session->setFlashdata('error', 'Akses tidak ditemukan.');
                    return redirect()->to('login');
                }
            }
        } elseif ($pesertadidik) {
            if ($pesertadidik && password_verify($password, $pesertadidik['password'])) {
                $session->set([
                    'id_pd' => $pesertadidik['id_pd'],
                    'nisn' => $pesertadidik['nisn'],
                    'nama_lengkap' => $pesertadidik['nama_lengkap'],
                    'role' => 'pd',
                    'logged_in' => true
                ]);
                return redirect()->to('peserta_didik');
            } else {
                $session->setFlashdata('error', 'Username atau Password salah.');
                return redirect()->to('login');
            }
        } elseif ($gtk) {
            if ($gtk && password_verify($password, $gtk['password'])) {
                $session->set([
                    'id_gtk' => $gtk['id_gtk'],
                    'kode_guru' => $gtk['kode_guru'],
                    'nama_lengkap' => $gtk['nama_lengkap'],
                    'role' => 'gtk',
                    'logged_in' => true
                ]);
                return redirect()->to('gtkuser');
            } else {
                $session->setFlashdata('error', 'Username atau Password salah.');
                return redirect()->to('login');
            }
        } else {
            $session->setFlashdata('error', 'Akun tidak ditemukan.');
            return redirect()->to('login');
        }

        $session->setFlashdata('error', 'Username atau Password salah.');
        return redirect()->to('login');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
}
