<?php

namespace App\Controllers\Gtk;

use App\Models\DurasiModel;
use App\Models\UserModel;
use App\Models\RombelModel;
use App\Models\KelasModel;
use App\Models\JadwalModel;
use App\Models\AbsenKelasModel;
use App\Models\PesertaDidikModel;

use CodeIgniter\API\ResponseTrait;
use App\Controllers\BaseController;

class Kbm extends BaseController
{
    use ResponseTrait;
    public function __construct()
    {
        $this->session = session();
        $this->modelUser = new UserModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelJadwal = new JadwalModel();
        $this->modelDurasi = new DurasiModel();
        $this->modelAbsenKelas = new AbsenKelasModel();
    }
    public function index()
    {
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        $namaHari = $hariIndo[$hariIni];

        $data = [
            "menu" => "gtk",
            "hari" => $namaHari,
        ];
        return view('gtk/kbm', $data);
    }

    function loadData()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        // $namaHari = $hariIndo[$hariIni];
        $namaHari = "Senin";
        $kode_guru = $this->session->get('kode_guru');
        $tgl_sekarang = date('Y-m-d');

        $jadwal = $this->modelJadwal->getRekapJadwalbyRombel($namaHari, $id_tahun, $kode_guru);
        echo "<div class='row'>";
        foreach ($jadwal as $row) {
            $rombel = $this->modelRombel->where('kode_rombel', $row['kode_rombel'])->first();
            // var_dump($rombel);
            echo "<div class='col-sm-4'>
                    <div class='col-12  d-flex'>
                        <div class='card flex-fill bg-white'>
                            <div class='card-body'>
                             <h4>" . $rombel['nama_rombel'] . " - Ruang. " . $row['ruangan'] . "</h4>
                            <table class='table'>
                            <tr>
                            <td>Jumlah Jam</td>
                            <td>:</td>
                            <td>" . $row['jumlah'] . "</td>
                            </tr>
                            </table>
                            ";
            $absen_kelas = $this->modelAbsenKelas
                ->where("rombel", $row['kode_rombel'])
                ->where("kode_guru", $kode_guru)
                ->where("tgl_absen", $tgl_sekarang)
                ->first();
            if ($absen_kelas) {
                if ($absen_kelas['status'] == 'mulai') {
                    echo " 
                    <div class='btn-group mt-4'>
                    <button type='button' class='btn btn-sm btn-primary' disbaled=''> <i class='fa fa-spinner fa-spin'></i> Kelas Dimulai</button>
                    <button type='button' class='btn btn-sm btn-secondary' onclick='absenKelas(" . $absen_kelas['id_absen_kelas'] . ")'>Absen Kelas</button>
                    <button type='button' class='btn btn-sm btn-danger' onclick='hapusKelas(" . $absen_kelas['id_absen_kelas'] . ")'>Batal Kelas</button>
                    <button type='button' class='btn btn-sm btn-success' onclick='selesaiKelas(" . $absen_kelas['id_absen_kelas'] . ")'>Selesai Kelas</button>
                    </div>";
                } else {
                    echo " 
                    <div class='btn-group mt-4'>
                    <button type='button' class='btn btn-sm btn-primary' disbaled=''>KBM Berakhir</button>
                    </div>";
                }
            } else {
                echo " <div class='btn-group mt-4'> <button type='button' class='btn  btn-sm btn-primary' onclick='mulaiKelas(&#96;" . $row['kode_rombel'] . "&#96;," . $row['id_jadwal'] . "," . $row['jumlah'] . ")'>Mulai Kelas</button>
              <button type='button' class='btn btn-sm btn-success' disabled>Selesai Kelas</button></div>";
            }

            echo " </div>
                        </div>
                    </div>
                </div>";
        }
        echo "</div>";
    }

    function mulaiKelas()
    {
        $kode_guru = $this->session->get('kode_guru');
        $nama_lengkap = $this->session->get('nama_lengkap');
        $kode_rombel = $this->request->getVar('rombel');
        $id_jadwal = $this->request->getVar('jadwal');
        $jml_jam = $this->request->getVar('jml_jam');

        $ruangan = $this->modelRombel->where('kode_rombel', $kode_rombel)->first();
        $tgl_sekarang = date('Y-m-d');
        $waktu_sekarang = date('H:i:s');

        $aksi = $this->modelAbsenKelas->save([
            'rombel' => $kode_rombel,
            'id_jadwal' => $id_jadwal,
            'jml_jam' => $jml_jam,
            'kode_guru' => $kode_guru,
            'status' => 'mulai',
            'tgl_absen' => $tgl_sekarang,
            'ruangan' => $ruangan['ruangan'],
            'nama_lengkap' => $nama_lengkap,
            'jam_masuk' => $waktu_sekarang,
        ]);

        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    function hapusKelas($id)
    {
        if ($this->modelAbsenKelas->delete($id)) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data deleted successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to delete data']);
        }
    }

    function selesaiKelas($id)
    {
        $waktu_sekarang = date('H:i:s');
        $aksi = $this->modelAbsenKelas->update($id, [
            'status' => 'selesai',
            'jam_selesai' => $waktu_sekarang
        ]);


        if ($aksi) {
            return $this->response->setJSON(['status' => 'success', 'message' => 'Data saved successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to saved data']);
        }
    }

    function loadDataKelas($id)
    {

        $absen_kelas = $this->modelAbsenKelas
            ->where('id_absen_kelas', $id)
            ->first();

        $master_pd = $this->modelPD
            ->where('kode_rombel', $absen_kelas['rombel'])
            ->find();

        echo "
        <table class='table newdata'>
        <thead>
        <tr>
            <th rowspan='2'>No</th>
            <th rowspan='2'>Nama lengkap</th>
            <th colspan='4' align='center'>Kehadiran</th>
        </tr>
        <tr>
            <th>H</th>
            <th>A</th>
            <th>I</th>
            <th>S</th>
        </tr>
        </thead>
        <tbody>";
        $no = 1;
        foreach ($master_pd as $pd) {
            echo "
            <tr>
            <td>" . $no++ . "</td>
            <td>" . $pd['nama_lengkap'] . "</td>
            </tr>
            ";
        }
        echo "</tbody>
        </table>

        ";
    }
}
