<?php

namespace App\Controllers\Gtk;

use App\Controllers\BaseController;
use App\Models\JadwalModel;
use App\Models\KelasModel;
use App\Models\DurasiModel;
use App\Models\RombelModel;

class Jadwal extends BaseController
{

    public function __construct()
    {
        $this->session = session();
        $this->modelJadwal = new JadwalModel();
        $this->modelRombel = new RombelModel();
        $this->modelKelas = new KelasModel();
        $this->modelDurasi = new DurasiModel();
    }
    public function index()
    {
        $id_tahun = tahun_pelajaran_aktif();
        $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            // 'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            // 'Saturday' => 'Sabtu'
        ];

        $data = [
            "menu" => "gtk",
            // "data" => $this->modelJadwal->getJadwalByHari($namaHari, $id_tahun),
            "jadwal" => $this->modelJadwal->findAll(),
            "rombel" => $this->modelRombel->findAll(),
            "kode_guru" => $this->session->get('kode_guru'),
            "hari" => $hariIndo,
        ];
        return view('gtk/jadwal', data: $data);
    }

    function loadJadwal()
    {
        // $hariIni = date('l'); // Mendapatkan nama hari dalam bahasa Inggris
        $hariIndo = [
            'Sunday' => 'Minggu',
            'Monday' => 'Senin',
            'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu',
            'Thursday' => 'Kamis',
            'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];

        // $namaHari = $hariIndo[$hariIni];
        echo "<div class='row'>";
        foreach ($hariIndo as $hari) {
            echo "
             <div class='col-lg-3'>
                        <div class='card flex-fill bg-white'>
                            <div class='card-header'>
                                <h4>" . $hari . "</h4>
                            </div>
                            <div class='card-body'>
                                <table class='table'>
                                    <thead>
                                        <tr>
                                            <th>Jml</th>
                                            <th>Rombel</th>
                                            <th>Ruangan</th>
                                        </tr>
                                    </thead>
                                    <tbody>";
            $id_tahun = tahun_pelajaran_aktif();
            $kode_guru = $this->session->get('kode_guru');
            $jadwal = $this->modelJadwal->getJadwalByHariGtk($hari, $id_tahun, $kode_guru);
            foreach ($jadwal as $row_jadwal) {
                echo "
                <tr>
                <td>" . $row_jadwal['jam_ke'] . "</td>
                <td>" . $row_jadwal['nama_rombel'] . "</td>
                <td>" . $row_jadwal['ruangan'] . "</td>
                </tr>
                ";
            }

            echo "</tbody>
                                </table>
                            </div>
                        </div>
                </div>
        ";
        }

        echo "</div>";
    }
}
