<?php

namespace App\Controllers;
use App\Models\AbsensiModel;
use App\Models\DeviceModel;
use App\Models\PesertaDidikModel;
use App\Models\TmpKartuModel;
use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
class Api extends BaseController
{
    public function __construct() {
        $this->modelAbsensi = new AbsensiModel();
        $this->modelReg = new TmpKartuModel();
        $this->modelPD = new PesertaDidikModel();
        $this->modelDevice = new DeviceModel();
    }
    public function index(): string
    {
        return view('welcome_message');
    }


    public function espReboot()
    {
        $device_id = $this->request->getPost('device_id');

        if (!$device_id) {
            return $this->response->setStatusCode(400)->setJSON(['message' => 'Device ID tidak valid']);
        }

        $this->modelDevice->where('kode_device', $device_id)
        ->set(['status' => 'online', 'last_seen' => date('Y-m-d H:i:s')])
        ->update();

        return $this->response->setJSON(['message' => 'ESP32 reboot terdeteksi'], 200);
    }

    public function cekKartu()
    {
        $rfid = $this->request->getPost('rfid');
        $absensiModel = new AbsensiModel();
        $tmpModel = new TmpKartuModel();

        $data = $absensiModel->where('rfid', $rfid)->first();

        if ($data) {
            $absensiModel->insert(['rfid' => $rfid]);
            return $this->response->setJSON(['message' => 'Absensi sukses'], 200);
        } else {
            $tmpModel->insert(['rfid' => $rfid]);
            return $this->response->setJSON(['message' => 'Kartu baru, perlu registrasi'], 201);
        }
    }


    public function registerESP()
    {
        $device_id = $this->request->getPost('device_id');
        $ip_address = $this->request->getPost('ip_address');

        if (!$device_id || !$ip_address) {
            return $this->response->setStatusCode(400)->setJSON(['message' => 'Device ID tidak valid']);
        }

        // $espModel = new ESPModel();

        // Cek apakah ESP32 sudah terdaftar
        $existing = $this->modelDevice->where('device_id', $device_id)->first();
        if ($existing) {
            return $this->response->setJSON(['message' => 'ESP32 sudah didaftarkan'], 201);
        }

        // Simpan ke database
        $this->modelDevice->insert([
            'device_id' => $device_id,
            'ip_address' => $ip_address,
            'status' => 'online',
            'last_seen' => date('Y-m-d H:i:s')
        ]);

        return $this->response->setJSON(['message' => 'ESP32 berhasil didaftarkan'], 201);
    }

    public function updateStatus()
    {
        $device_id = $this->request->getPost('device_id');
        $ip_address = $this->request->getPost('ip_address');


        if (!$device_id) {
            return $this->response->setStatusCode(400)->setJSON(['message' => 'Device ID tidak valid']);
        }

        $espModel = new ESPModel();

        // Update status ESP32
        $espModel->where('device_id', $device_id)->set([
            'status' => 'online',
            'ip_address' => $ip_address,
            'last_seen' => date('Y-m-d H:i:s')
        ])->update();

        return $this->response->setJSON(['message' => 'ESP32 berhasil diperbaharui'], 201);
    }

    public function getDevices()
    {
        $espModel = new ESPModel();
        $devices = $espModel->findAll();

        return $this->response($devices, 200);
    }


}
