<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'login::index');
// $routes->get('login', 'login::index');
// $routes->get('panel', 'Panel\Home::index');
$routes->get('piket', 'Piket\Home::index');
// $routes->get('pesertaDidik', 'Panel\Home::pesertaDidik');

// Router Array Panel
$routeArray = [
    ['GET', 'panel', 'Panel\Home::index'],
    // ['GET', 'gtk', 'Panel\Home::gtk'],
];

foreach ($routeArray as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

//sign_in
$routeLogin = [
    ['GET', 'login', 'Login::index'],
    ['POST', 'login/sign_in', 'Login::SignIn'],
    ['GET', 'login/sign_out', 'Login::logout'],
    // ['GET', 'gtk', 'Panel\Home::gtk'],
];

foreach ($routeLogin as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

// Router Array tahunAjaran
$routeTahunAjaran = [
    ['GET', 'tahunAjaran', 'Panel\Akademik::tahunAjaran'],
    ['POST', '/tahunAjaran/save_tahunAjaran', 'Panel\Akademik::save_tahunAjaran'],
    ['GET', '/tahunAjaran/getData_tahunAjaran/(:num)', 'Panel\Akademik::getData_tahunAjaran/$1'],
    ['DELETE', '/tahunAjaran/delete_tahunAjaran/(:num)', 'Panel\Akademik::delete_tahunAjaran/$1'],
];

foreach ($routeTahunAjaran as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// Router Array mapel
$routeMapel = [
    ['GET', 'mapel', 'Panel\Akademik::mapel'],
    ['GET', '/mapel/getAll', 'Panel\Akademik::getAll_mapel'],
    ['POST', '/mapel/save_mapel', 'Panel\Akademik::save_mapel'],
    ['POST', '/mapel/import', 'Panel\Akademik::import_mapel'],
    ['GET', '/mapel/getData_mapel/(:segment)', 'Panel\Akademik::getData_mapel/$1'],
    ['PUT', '/mapel/update/(:segment)', 'Panel\Akademik::update_mapel/$1'],
    ['DELETE', '/mapel/delete_mapel/(:segment)', 'Panel\Akademik::delete_mapel/$1'],
];

foreach ($routeMapel as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// Router Array Kelas
$routeKelas = [
    ['GET', 'kelas', 'Panel\Akademik::kelas'],
    ['GET', '/kelas/getAll', 'Panel\Akademik::getAll_kelas'],
    ['POST', '/kelas/save_kelas', 'Panel\Akademik::save_kelas'],
    ['GET', '/kelas/getData_kelas/(:segment)', 'Panel\Akademik::getData_kelas/$1'],
    ['PUT', '/kelas/update/(:segment)', 'Panel\Akademik::update_kelas/$1'],
    ['DELETE', '/kelas/delete_kelas/(:segment)', 'Panel\Akademik::delete_kelas/$1'],
];

foreach ($routeKelas as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

// Router Array Rombel
$routeKelas = [
    ['GET', 'rombel', 'Panel\Akademik::rombel'],
    ['GET', '/rombel/getAll', 'Panel\Akademik::getAll_rombel'],
    ['POST', '/rombel/save_rombel', 'Panel\Akademik::save_rombel'],
    ['GET', '/rombel/getData_rombel/(:segment)', 'Panel\Akademik::getData_rombel/$1'],
    ['PUT', '/rombel/update/(:segment)', 'Panel\Akademik::update_rombel/$1'],
    ['DELETE', '/rombel/delete_rombel/(:segment)', 'Panel\Akademik::delete_rombel/$1'],
];

foreach ($routeKelas as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

// Router Array GTK
$routeGtk = [
    ['GET', 'gtk', 'Panel\Gtk::index'],
    ['GET', '/gtk/getAll', 'Panel\Gtk::getAll_gtk'],
    ['POST', '/gtk/save_gtk', 'Panel\Gtk::save_gtk'],
    ['POST', '/gtk/import', 'Panel\Gtk::import_gtk'],
    ['GET', '/gtk/getData_gtk/(:segment)', 'Panel\Gtk::getData_gtk/$1'],
    ['PUT', '/gtk/update/(:segment)', 'Panel\Gtk::update_gtk/$1'],
    ['DELETE', '/gtk/delete_gtk/(:segment)', 'Panel\Gtk::delete_gtk/$1'],
];

foreach ($routeGtk as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// Router Array User
$routeUser = [
    ['GET', 'user', 'Panel\User::index'],
    ['GET', '/user/getAll', 'Panel\User::getAll_user'],
    ['POST', '/user/save_user', 'Panel\User::save_user'],
    ['POST', '/user/import', 'Panel\User::import_user'],
    ['GET', '/user/getData_user/(:segment)', 'Panel\User::getData_user/$1'],
    ['PUT', '/user/update/(:segment)', 'Panel\User::update_user/$1'],
    ['POST', '/user/update/(:segment)', 'Panel\User::update_user/$1'],
    ['DELETE', '/user/delete_user/(:segment)', 'Panel\User::delete_user/$1'],
];

foreach ($routeUser as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

// Router Array Peserta Didik
$routePesertaDidik = [
    ['GET', 'pesertaDidik', 'Panel\PesertaDidik::index'],
    ['GET', '/pesertaDidik/getAll', 'Panel\PesertaDidik::getAll'],
    ['POST', '/pesertaDidik/save', 'Panel\PesertaDidik::save'],
    ['POST', '/pesertaDidik/import', 'Panel\PesertaDidik::import'],
    ['GET', '/pesertaDidik/getData/(:segment)', 'Panel\PesertaDidik::getData/$1'],
    ['GET', '/pesertaDidik/getDataView/(:segment)', 'Panel\PesertaDidik::getDataView/$1'],
    ['PUT', '/pesertaDidik/update/(:segment)', 'Panel\PesertaDidik::update/$1'],
    ['POST', '/pesertaDidik/update/(:segment)', 'Panel\PesertaDidik::update/$1'],
    ['DELETE', '/pesertaDidik/delete/(:segment)', 'Panel\PesertaDidik::delete/$1'],
];

foreach ($routePesertaDidik as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// Router Array Jurusan
$routeJurusan = [
    ['GET', 'jurusan', 'Panel\Akademik::jurusan'],
    ['GET', '/jurusan/getAll', 'Panel\Akademik::getAll_jurusan'],
    ['POST', '/jurusan/save_jurusan', 'Panel\Akademik::save_jurusan'],
    ['GET', '/jurusan/getData_jurusan/(:segment)', 'Panel\Akademik::getData_jurusan/$1'],
    ['PUT', '/jurusan/update/(:segment)', 'Panel\Akademik::update_jurusan/$1'],
    ['DELETE', '/jurusan/delete_jurusan/(:segment)', 'Panel\Akademik::delete_jurusan/$1'],
];

foreach ($routeJurusan as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// Router Array Jadwal
$routeJadwal = [
    ['GET', 'jadwal', 'Panel\Jadwal::index'],
    ['GET', '/jadwal/getAll', 'Panel\Jadwal::getAll'],
    ['GET', '/jadwal/LoadJadwal', 'Panel\Jadwal::LoadJadwal'],
    ['GET', '/jadwal/waktuBelajar', 'Panel\Jadwal::waktuBelajar'],
    ['POST', '/jadwal/save', 'Panel\Jadwal::save'],
    ['PUT', '/jadwal/saveJadwal', 'Panel\Jadwal::saveJadwal'],
    ['GET', '/jadwal/generate', 'Panel\Jadwal::generateJadwalPost'],
    ['POST', '/jadwal/saveWaktu', 'Panel\Jadwal::saveWaktu'],
    ['POST', '/jadwal/updateJadwal', 'Panel\Jadwal::updateJadwal'],
    ['GET', '/jadwal/getData/(:segment)', 'Panel\Jadwal::getData/$1'],
    ['PUT', '/jadwal/update/(:segment)', 'Panel\Jadwal::update/$1'],
    ['DELETE', '/jadwal/delete/(:segment)', 'Panel\Jadwal::delete/$1'],
    ['DELETE', '/jadwal/deleteWaktu/(:segment)', 'Panel\Jadwal::deleteWaktu/$1'],
];

foreach ($routeJadwal as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//jadwalPreview
$routeJadwalView = [
    ['GET', 'jadwalPreview', 'Panel\Jadwal::jadwalPreview'],
    // ['GET', 'jadwalPreview', 'Panel\Jadwal::LoadJadwalPDf'],
    ['GET', '/jadwalPreview/LoadJadwalPDf', 'Panel\Jadwal::LoadJadwalPDf'],
];

foreach ($routeJadwalView as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}



//Device
$routeDevice = [
    ['GET', 'device', 'Panel\Device::listDevice'],
    ['GET', 'device/getAll', 'Panel\Device::getAll'],
    ['POST', 'device/reboot', 'Panel\Device::reboot'],
    ['POST', '/device/save', 'Panel\Device::save'],
    ['GET', '/device/getData/(:segment)', 'Panel\Device::getData/$1'],
    ['PUT', '/device/update/(:segment)', 'Panel\Device::update/$1'],
    ['DELETE', '/device/delete/(:segment)', 'Panel\Device::delete/$1'],
];

foreach ($routeDevice as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//Card
$routeCard = [
    ['GET', 'card', 'Panel\Card::index'],
    ['GET', 'card/load_data_reg', 'Panel\Card::loadDataReg'],
    ['GET', 'card/load_data_pesertadidik', 'Panel\Card::loadDataPesertaDidik'],
    ['POST', 'card/updateKey', 'Panel\Card::updateKey'],
];

foreach ($routeCard as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//ESP32
$routeEsp32 = [
    ['GET', 'api', 'Api::index'],
    ['POST', 'api/esp_reboot', 'Api::espReboot'],
    ['POST', 'api/cek_kartu', 'Api::cekKartu'],
    ['POST', 'api/register_esp', 'Api::registerESP'],
    ['POST', 'api/updateStatus', 'Api::updateStatus'],
    // ['GET', 'jadwalPreview', 'Panel\Jadwal::LoadJadwalPDf'],
];

foreach ($routeEsp32 as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//piket_absensi
$routePiket = [
    ['GET', 'absensi', 'Piket\Absensi::index'],
    ['GET', '/absensi/load_absensi', 'Piket\Absensi::loadAbsensi'],
    ['POST', '/setwaktu/save/(:segment)', 'Piket\Absensi::saveSetWaktu/$1'],
    ['GET', '/setwaktu/getData/(:segment)', 'Piket\Absensi::getDataWaktu/$1'],
];

foreach ($routePiket as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

//piket_absensi
$routeHomePiket = [
    ['GET', '/piket/load_absensi', 'Piket\Home::loadAbsensi'],
];

foreach ($routeHomePiket as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

//piket_Jadwal 
$routeJadwalPiket = [
    ['GET', 'view_jadwal', 'Piket\Jadwal::index'],
    ['GET', 'all_view_jadwal', 'Piket\Jadwal::AllViewJadwal'],
    ['GET', 'all_view_jadwal/LoadJadwal', 'Piket\Jadwal::LoadAllViewJadwal'],
    // // ['POST', '/setwaktu/save', 'Piket\Absensi::saveSetWaktu'],
    // ['POST', '/setwaktu/save/(:segment)', 'Piket\Absensi::saveSetWaktu/$1'],
    // ['GET', '/setwaktu/getData/(:segment)', 'Piket\Absensi::getDataWaktu/$1'],
];

foreach ($routeJadwalPiket as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//gtkPiket
$routeGtkPiket = [
    ['GET', 'gtkPiket', 'Piket\Gtk::index'],
];

foreach ($routeGtkPiket as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//PdPiket
$routePdPiket = [
    ['GET', 'PdPiket', 'Piket\PesertaDidik::index'],
];

foreach ($routePdPiket as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//Kelas Live
$routeKelasLive = [
    ['GET', 'kelasLive', 'Piket\Jadwal::kelasLive'],
];

foreach ($routeKelasLive as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


//Kelas Live
$routeGtkUser = [
    ['GET', 'gtkuser', 'Gtk\Home::index'],
    ['GET', 'kbm', 'Gtk\Kbm::index'],
    ['GET', 'kbm/load_data_kelas/(:segment)', 'Gtk\Kbm::loadDataKelas/$1'],
    ['GET', 'kbm/loadData', 'Gtk\Kbm::loadData'],
    ['POST', 'kbm/mulai_kelas', 'Gtk\Kbm::mulaiKelas'],
    ['GET', 'kbm/hapus_kelas/(:segment)', 'Gtk\Kbm::hapusKelas/$1'],
    ['GET', 'kbm/selesai_kelas/(:segment)', 'Gtk\Kbm::selesaiKelas/$1'],
    ['GET', 'jadwalgtk', 'Gtk\Jadwal::index'],
    ['GET', 'gtkprofil', 'Gtk\Home::profile'],
    ['GET', 'gtk/load_jadwal', 'Gtk\Jadwal::loadJadwal'],
];

foreach ($routeGtkUser as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}

//peserta_didik
$routePdUser = [
    ['GET', 'peserta_didik', 'PesertaDidik\Home::index'],
    ['GET', 'pd_jadwal', 'PesertaDidik\Jadwal::index'],
    ['GET', 'pd_profile', 'PesertaDidik\Home::index'],
    ['GET', 'pd_pertemuan', 'PesertaDidik\Home::index'],
    ['GET', 'pd_kartu', 'PesertaDidik\Absensi::rekapAbsenKartu'],
    ['GET', 'pd/load_jadwal', 'PesertaDidik\Jadwal::loadJadwal'],
    ['GET', 'pd/load_rekap_kartu', 'PesertaDidik\Absensi::loadRekapKartu'],

];

foreach ($routePdUser as $route) {
    $routes->{$route[0]}($route[1], $route[2]);
}


// $routes->post(from: 'api/esp_reboot', 'ESPController::espReboot');
// $routes->post('api/cek_kartu', 'ESPController::cekKartu');
// $routes->get('esp32/status', 'ESPController::getStatus');
